/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences.view;

import java.util.ArrayList;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionImplNode;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MTJManagerViewUI {

	/**
	 * 
	 */
	protected ArrayList _tableData = new ArrayList();
	/**
	 * 
	 */
	private Table _tableList;
	/**
	 * 
	 */
	private TableViewer tableViewer;
	
	/**
	 * 
	 */
	private Button _moveUp;
	private Button _moveDown;
	private Button _selAll;
	private Button _unselAll;	
	private Button _showDetail;
	
	/**
	 * 
	 */
	private Label _description;
	private Label _label;
	private Label _labelMessage;	
	
	//private Control _control;
	
	private String[] columns;

	private Composite result;

	/**
	 * 
	 */
	public MTJManagerViewUI(String[] _columns) {
		columns = _columns;
		
	}

	/**
	 * @param parent
	 * @return
	 */
	private Composite createContainer(Composite parent){

		Composite result = new Composite(parent, SWT.NONE);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 15;
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 350;
		data.widthHint = 350;
		result.setLayoutData(data);
		return result;
	}
	
	/**
	 * @param parent
	 * @return
	 */
	public Control createControl(Composite parent) {
				
		GridData data;		
		Composite composite = createContainer(parent);

		_description = new Label(composite, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		_description.setLayoutData(data);		

		createTableViewer(composite);
		
		_tableList = tableViewer.getTable(); 
		

		Composite buttonWidget = new Composite(composite, SWT.NULL);
		data = new GridData();
		data.grabExcessVerticalSpace = true;
		data.horizontalIndent = 20;
		data.verticalAlignment = GridData.FILL;		
		buttonWidget.setLayoutData(data);
		GridLayout blayout = new GridLayout();
		blayout.numColumns = 1;
		blayout.marginHeight = 25;
		buttonWidget.setLayout(blayout);

		_moveUp = createButton(buttonWidget, Messages.MTJManagerViewUI_Up);
		_moveDown = createButton(buttonWidget, Messages.MTJManagerViewUI_Down);
		_selAll = createButton(buttonWidget, Messages.MTJManagerViewUI_SelectAll);
		_unselAll = createButton(buttonWidget, Messages.MTJManagerViewUI_UnSelect);

		_showDetail = createButton(buttonWidget, Messages.MTJManagerViewUI_Info);
		
		
		_moveUp.setEnabled(false);
		_moveDown.setEnabled(false);
			
		_labelMessage = new Label(composite, SWT.None);
		
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 1;
		_labelMessage.setLayoutData(data);
		
		//_control = composite;

		setDescription(Messages.MTJManagerViewUI_MtjCoreServiceFrameworks);

		result = composite;
		return composite;
	}

	
	/**
	 * @return Composite
	 */
	public Composite getControl() {
		return result;
	}

	
	private void createTableViewer(Composite parent) {
		// Create the table viewer.
		tableViewer = new TableViewer(
					parent,
					SWT.BORDER | SWT.CHECK | SWT.SINGLE |SWT.H_SCROLL |SWT.V_SCROLL| SWT.FULL_SELECTION );

		// Create the table control.
		Table table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		GridData data = GridUtil.createFill();
		data.heightHint = 50;
		data.widthHint = 100;
		table.setLayoutData(data);

		TableLayout tableLayout = new TableLayout();
		CellEditor[] cellEditors = new CellEditor[columns.length];

		TableColumn nameColumn = new TableColumn(table, SWT.LEFT);
		nameColumn.setText(Messages.MTJManagerViewUI_Name); //MtjCoreUIPlugin.getResourceString("STR_PREF_SERVICENAME")
		nameColumn.setWidth(60);
		tableLayout.addColumnData(new ColumnPixelData(120));
		cellEditors[0] = new TextCellEditor(table);

		TableColumn vendorColumn = new TableColumn(table, SWT.LEFT);
		vendorColumn.setText(Messages.MTJManagerViewUI_Vendor);
		vendorColumn.setWidth(60);
		tableLayout.addColumnData(new ColumnPixelData(110));

		TableColumn versionColumn = new TableColumn(table, SWT.LEFT);
		versionColumn.setText(Messages.MTJManagerViewUI_Version);
		versionColumn.setWidth(10);
		tableLayout.addColumnData(new ColumnPixelData(40));
		
		table.setLayout(tableLayout);

		// Adjust the table viewer.
		tableViewer.setColumnProperties(columns);

	}
	
	/**
	 * @param parent
	 * @param label
	 * @return
	 */
	private Button createButton(Composite parent, String label){
		GridData data;
		Button btn = new Button(parent, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		btn.setLayoutData(data);
		btn.setText(label);
		return btn;
	}
	
	/**
	 * @param descr
	 */
	protected void setDescription(String descr){
		_description.setText(descr);	
	}
	
	/**
	 * @param label
	 */
	protected void setLabel(String label){
		_label.setText(label);
	}
	
	

	/**
	 * @param filter
	 * @param _data
	 */
	protected void createColumnDataFromString(String filter, ArrayList _data){
	}	

	protected void loadColumnData(String _filter, ArrayList _data, Table _list, IPreferenceStore store){
		for (int idx = 0; idx < _tableList.getItemCount(); idx++) {		
			TableItem _item = _tableList.getItem(idx);
			ExtensionImplNode _cd = (ExtensionImplNode)_item.getData();
			MtjExtension _m = null;
			if (_cd.getImpl() instanceof MtjExtension){
				_m = (MtjExtension)_cd.getImpl();
				_item.setChecked(_m.isActive());
			}
		}	
			
	}
	protected void saveColumnData(String _filter, ArrayList _data, Table _list, IPreferenceStore store){
	}	

	/**
	 * @return Returns the _moveDown.
	 */
	public Button get_moveDown() {
		return _moveDown;
	}

	/**
	 * @param down The _moveDown to set.
	 */
	public void set_moveDown(Button down) {
		_moveDown = down;
	}

	/**
	 * @return Returns the _moveUp.
	 */
	public Button get_moveUp() {
		return _moveUp;
	}

	/**
	 * @param up The _moveUp to set.
	 */
	public void set_moveUp(Button up) {
		_moveUp = up;
	}

	/**
	 * @return Returns the _selAll.
	 */
	public Button get_selAll() {
		return _selAll;
	}

	/**
	 * @param all The _selAll to set.
	 */
	public void set_selAll(Button all) {
		_selAll = all;
	}

	/**
	 * @return Returns the _showDetail.
	 */
	public Button get_showDetail() {
		return _showDetail;
	}

	/**
	 * @param detail The _showDetail to set.
	 */
	public void set_showDetail(Button detail) {
		_showDetail = detail;
	}

	/**
	 * @return Returns the _unselAll.
	 */
	public Button get_unselAll() {
		return _unselAll;
	}

	/**
	 * @param all The _unselAll to set.
	 */
	public void set_unselAll(Button all) {
		_unselAll = all;
	}


	/**
	 * @return Returns the _tableData.
	 */
	public ArrayList get_tableData() {
		return _tableData;
	}

	/**
	 * @param data The _tableData to set.
	 */
	public void set_tableData(ArrayList data) {
		_tableData = data;
	}

	/**
	 * @return Returns the _tableList.
	 */
	public Table get_tableList() {
		return _tableList;
	}

	/**
	 * @param list The _tableList to set.
	 */
	public void set_tableList(Table list) {
		_tableList = list;
	}


	/**
	 * @return Returns the tableViewer.
	 */
	public TableViewer getTableViewer() {
		return tableViewer;
	}

	/**
	 * @param tableViewer The tableViewer to set.
	 */
	public void setTableViewer(TableViewer tableViewer) {
		this.tableViewer = tableViewer;
	}

	/**
	 * @return Returns the _description.
	 */
	public Label get_description() {
		return _description;
	}

	/**
	 * @param _description The _description to set.
	 */
	public void set_description(Label _description) {
		this._description = _description;
	}

	/**
	 * @return Returns the _label.
	 */
	public Label get_label() {
		return _label;
	}

	/**
	 * @param _label The _label to set.
	 */
	public void set_label(Label _label) {
		this._label = _label;
	}

	/**
	 * @return Returns the _labelMessage.
	 */
	public Label get_labelMessage() {
		return _labelMessage;
	}

	/**
	 * @param message The _labelMessage to set.
	 */
	public void set_labelMessage(Label message) {
		_labelMessage = message;
	}		
	/**
	 * return true if all items in Table is unchecked
	 */
	protected boolean ifAllItemsIsUnchecked(){
		for(int idx=0; idx<_tableList.getItemCount(); idx++){
			if(_tableList.getItem(idx).getChecked()){	
				return false;
			}		
		}
		return true;
	}
	
}
