/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.util;

import org.eclipse.swt.layout.GridData;

public class GridUtil {

	
	/**
	 * 
	 */
	public GridUtil() {
		super();
	}
	
	/**
	 * Creates a grid data object that occupies vertical and horizontal
	 * space.
	 */
	static public GridData createFill() {
		GridData gd= new GridData();
		gd.horizontalAlignment= GridData.FILL;
		gd.grabExcessHorizontalSpace= true;
		gd.verticalAlignment= GridData.FILL;
		gd.grabExcessVerticalSpace= true;
		return gd;
	}
	/**
	 * Creates a grid data object that occupies horizontal space.
	 */
	static public GridData createHorizontalFill() {
		GridData gd= new GridData();
		gd.horizontalAlignment= GridData.FILL;
		gd.grabExcessHorizontalSpace= true;
		return gd;
	}
	/**
	 * Creates a grid data object that occupies vertical space.
	 */
	static public GridData createVerticalFill() {
		GridData gd= new GridData();
		gd.verticalAlignment= GridData.FILL;
		gd.grabExcessVerticalSpace= true;
		return gd;
	}
	
}
