/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.bp.eclipse;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.extension.BuildProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.javame.JavaMePackaging;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpPackaging;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpPreverify;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpSigning;

public class BuildProviderImpl extends MtjExtensionImpl implements
		BuildProvider {
	
	public BuildProviderImpl() {
		super();
		
		setId("org.eclipse.mtj.extension.bp.eclipse"); //$NON-NLS-1$
		setDescription(Messages.BuildProviderImpl_PluginDescription);
		setVendor(Messages.BuildProviderImpl_PluginProvider); 
		setVersion(Messages.BuildProviderImpl_PluginVersion); 
		setType(ExtensionType.BUILD_PROVIDER_LITERAL);
		
	}
	
	public BuildType[] getSupportedTypes() throws MtjException {
		BuildType[] ret = { BuildType.BUILD_TYPE_ECLIPSE_LITERAL };
		return ret;
	}

	public Deployment build(IMtjProject mtjProject, String projectNatureId, BuildType type,
			RuntimePlatformDefinition targetPlatform,
			IProgressMonitor monitor) throws MtjException {
		
		if (mtjProject.getProjectData().getType() == ProjectType.PROJECT_TYPE_MIDP_LITERAL)
		{
			try {

				MidpSigning midpSigning = new MidpSigning(mtjProject, monitor);
				midpSigning.preemtSign();
				
				MidpPreverify preVerify = new MidpPreverify (mtjProject, monitor);
				preVerify.performPreverify(targetPlatform);
				
				MidpPackaging packaging = new MidpPackaging (mtjProject, monitor);
				packaging.performPackaging(projectNatureId);
				
				if(midpSigning.canSign())
					midpSigning.sign();
				
				
			} catch (MtjException e) {
				throw e;
			} catch (CoreException e) {
				throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.PACKAGING_ERROR), e);
			}
		}
		else
		{
			try {
				JavaMePackaging packaging = new JavaMePackaging (mtjProject, monitor);
				packaging.performPackaging(projectNatureId);
			} catch (MtjException e) {
				throw e;
			} catch (CoreException e) {
				throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.PACKAGING_ERROR), e);
			}

		}
		return null;
	}
}
