/*******************************************************************************
* Copyright (c) 2005,2006 IBM and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.bp.eclipse;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.PackagingProvider;
import org.eclipse.mtj.api.extension.SigningProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.core.IEclipseMtjCoreConstants;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.sp.ui.utils.SpUtils;
import org.eclipse.swt.widgets.Shell;

public class BuildProviderUtil  {

	static Shell shell = null;

	public static DeploymentType getDeploymentType (IMtjProject mtjProject) throws CoreException
	{
		DeploymentType dtype = mtjProject.getDeploymentType();

		return dtype;
	}
	

	public static PackagingProvider getPackagingProvider (IMtjProject mtjProject, DeploymentType dtype) throws MtjException, CoreException
	{
		PackagingProvider provider = getPackagingProvider(mtjProject.getProject(), dtype);
		if ( provider == null ) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.PACKAGING_PROVIDER_NOT_FOUND_ERROR));
		} 
		
		return provider;
	}
		
	public static PackagingProvider getPackagingProvider(IProject project, DeploymentType dtype) throws MtjException, CoreException {
		
		MtjExtension[] extensions = 
			MtjServices.getInstance().getImplementations(ExtensionType.PACKAGING_PROVIDER_LITERAL, null, null,true);
		for (int i = 0; i < extensions.length; i++) {
			PackagingProvider prov = (PackagingProvider)extensions[i];
			DeploymentType[] types = prov.getSupportedTypes();
			for (int j = 0; j < types.length; j++) {
				if ( types[j].getValue() == dtype.getValue() ) {
					return prov;
				}
			}
		}
		return null;
	}
	
	public static SigningProvider getSigningProvider(IProject project, DeploymentType dtype) throws MtjException {
	 	
		//get all active Signing providers
		//MtjExtension[] signingList = MtjServices.getInstance().getImplementations(ExtensionType.SIGNING_PROVIDER_LITERAL, null, null, true);
		MtjExtension[] signingList = (SigningProvider[])SpUtils.getSigningProvidersList();
		
		//set the active Signing Provider
		for(int i = 0; i < signingList.length; i++){
			if (((SigningProvider)signingList[i]).isActive()){
				SigningProvider prov = (SigningProvider)signingList[i];
				DeploymentType[] types = prov.getSupportedTypes();
				for (int j = 0; j < types.length; j++) {
					if ( types[j].getValue() == dtype.getValue() ) {
						return prov;
					}
				}
			}
		}
		return null;
	}
	
	public static void displayBuildMessage(MtjException e, String title, String body, int error) {
		if (shell == null)
			shell = MtjCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();

		if (error == IStatus.ERROR){
			ErrorDialog.openError (	shell
					, title
					, body
					, new Status( error, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e.toString(), e)
					);
		} else {
			MessageDialog.openInformation(shell, title, body);
		}
		
		
		
	}

}
