/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplm.impl;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentManagement;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.util.MtjEmfUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dplm.DeploymentManagementPlugin;
import org.eclipse.mtj.extension.dplm.Messages;

public class DeploymentManagementImpl
extends MtjExtensionImpl
implements DeploymentManagement {
    public DeploymentManagementImpl() {
        this.setId(DeploymentManagementPlugin.getDefault().getBundle().getSymbolicName());
        this.setDescription(Messages.DeploymentManagementImpl_PluginDescription);
        this.setVendor(Messages.DeploymentManagementImpl_PluginVendor);
        this.setVersion(Messages.DeploymentManagementImpl_PluginVersion);
        this.setType(ExtensionType.DEPLOYMENT_MANAGEMENT_LITERAL);
    }

    public Device[] getTargetDevices(RuntimePlatformDefinition runtimePlatformDefinition) throws MtjException {
        Device[] devices = null;
        ArrayList<Device> devs = new ArrayList<Device>();
        if (runtimePlatformDefinition != null) {
            EList eList = runtimePlatformDefinition.getDevices();
            int i = 0;
            while (i < eList.size()) {
                Device d = (Device)eList.get(i);
                DeploymentProvider dp = this.getDeploymentProvider(d);
                if (dp != null) {
                    devs.add(d);
                }
                ++i;
            }
        }
        devices = new Device[devs.size()];
        int i = 0;
        while (i < devs.size()) {
            devices[i] = (Device)devs.get(i);
            ++i;
        }
        return devices;
    }

    public void deploy(Deployment deployment, Device[] devices, DeviceCommunicationProtocol transferProtocol, IProgressMonitor monitor) throws MtjException {
        DeploymentProvider deploymentProvider = null;
        int i = 0;
        while (i < devices.length) {
            deploymentProvider = this.getDeploymentProvider(devices[i]);
            if (deploymentProvider == null) {
                throw new MtjException(String.valueOf(Messages.DeploymentManagementImpl_DeploymentProviderNotDefined) + MtjEmfUtil.toString((Device)devices[i]));
            }
            deploymentProvider.deploy(deployment, devices, transferProtocol, monitor);
            ++i;
        }
    }

    public DeploymentProvider getDeploymentProvider(Device device) {
        MtjExtension[] deploymentProviderList = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null);
        if (deploymentProviderList.length == 0) {
            return null;
        }
        int i = 0;
        while (i < deploymentProviderList.length) {
            try {
                Device[] devices = ((DeploymentProvider)deploymentProviderList[i]).getDevices();
                if (devices.length != 0) {
                    int j = 0;
                    while (j < devices.length) {
                        if (MtjEmfUtil.equals((Device)device, (Device)devices[j])) {
                            return (DeploymentProvider)deploymentProviderList[i];
                        }
                        ++j;
                    }
                }
            }
            catch (MtjException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return null;
    }
}

