/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.preverify.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mtj.extension.preverify.internal.PreverificationClassNode;
import org.eclipse.mtj.extension.preverify.internal.PreverifierMethodNode;
import org.eclipse.mtj.extension.preverify.internal.SimpleVerifierPlusClassloader;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.attrs.StackMapAttribute;
import org.objectweb.asm.attrs.StackMapFrame;
import org.objectweb.asm.attrs.StackMapType;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class MethodRewriter {
    private PreverificationClassNode classNode;
    private PreverifierMethodNode srcMethod;
    private MethodNode updatedMethod;
    private Map subroutineMap;
    private Map lineNumberMap;
    private Map localVariableByStartLabelMap;
    private Map localVariableByEndLabelMap;

    public MethodRewriter(PreverificationClassNode classNode, PreverifierMethodNode srcMethod) {
        this.classNode = classNode;
        this.srcMethod = srcMethod;
        this.localVariableByEndLabelMap = new HashMap();
    }

    public MethodNode getUpdatedMethod() throws AnalyzerException {
        boolean inliningRequired;
        boolean bl = inliningRequired = this.srcMethod.getJsrInstructionIndices().size() > 0;
        if (inliningRequired) {
            this.inlineSubroutines();
        } else {
            this.updatedMethod = this.srcMethod;
        }
        this.createStackMapAttribute();
        return this.updatedMethod;
    }

    private void createStackMapAttribute() throws AnalyzerException {
        StackMapAttribute stackMapAttribute = new StackMapAttribute();
        Set targetLabels = this.findTargetLabels();
        SimpleVerifierPlusClassloader interpreter = new SimpleVerifierPlusClassloader(this.classNode.getClassLoader());
        Analyzer analyzer = new Analyzer((Interpreter)interpreter);
        Frame[] frames = analyzer.analyze(this.classNode.name, this.updatedMethod);
        int deadCodeFrameCount = 0;
        int[] deadCodeIndices = new int[frames.length];
        int i = 0;
        while (i < this.updatedMethod.instructions.size()) {
            Frame frame = frames[i];
            AbstractInsnNode insnNode = this.getInstruction(this.updatedMethod, i);
            if (insnNode.getType() == 7) {
                LabelNode labelNode = (LabelNode)insnNode;
                if (targetLabels.contains(labelNode.label) && frame != null) {
                    stackMapAttribute.frames.add(this.newStackMapFrame(labelNode.label, frame));
                }
            } else if (frame == null) {
                deadCodeIndices[deadCodeFrameCount++] = i;
            }
            ++i;
        }
        if (stackMapAttribute.frames.size() != 0) {
            this.updatedMethod.visitAttribute((Attribute)stackMapAttribute);
            i = deadCodeFrameCount - 1;
            while (i >= 0) {
                this.updatedMethod.instructions.remove(deadCodeIndices[i]);
                --i;
            }
        }
    }

    private void inlineSubroutines() throws AnalyzerException {
        Region methodRegion = new Region(0, this.srcMethod.instructions.size());
        this.createSubroutineMap();
        this.sortTryCatchBlocks(methodRegion);
        this.updatedMethod = this.copyMethodMetadata(this.srcMethod);
        this.lineNumberMap = this.createLineNumberMap();
        this.localVariableByStartLabelMap = this.createLocalVariableMap();
        this.copyRegion(this.updatedMethod, methodRegion);
        if (this.shouldReduceVariableVisibility(this.updatedMethod)) {
            List instructions = this.updatedMethod.instructions;
            int instructionCount = instructions.size();
            AbstractInsnNode lastLabel = (AbstractInsnNode)instructions.remove(instructionCount - 1);
            instructions.add(instructionCount - 2, lastLabel);
        }
        this.updatedMethod.visitMaxs(this.srcMethod.maxStack, this.srcMethod.maxLocals);
    }

    private void addNewLocalVariableByEnd(LocalVariableNode newLocalVariable) {
        ArrayList<LocalVariableNode> endLocalVariables = (ArrayList<LocalVariableNode>)this.localVariableByEndLabelMap.get(newLocalVariable.end);
        if (endLocalVariables == null) {
            endLocalVariables = new ArrayList<LocalVariableNode>();
            this.localVariableByEndLabelMap.put(newLocalVariable.end, endLocalVariables);
        }
        endLocalVariables.add(newLocalVariable);
    }

    private void addStackMapType(List localOrStack, Label label, Value value) {
        BasicValue basicValue = (BasicValue)value;
        if (this == BasicValue.UNINITIALIZED_VALUE) {
            localOrStack.add(this.newStackMapType(label, 8));
        } else {
            Type valueType = basicValue.getType();
            if (valueType == null) {
                localOrStack.add(this.newStackMapType(label, 0));
            } else {
                switch (valueType.getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        localOrStack.add(this.newStackMapType(label, 1));
                        break;
                    }
                    case 8: {
                        localOrStack.add(this.newStackMapType(label, 3));
                        localOrStack.add(this.newStackMapType(label, 0));
                        break;
                    }
                    case 6: {
                        localOrStack.add(this.newStackMapType(label, 2));
                        break;
                    }
                    case 7: {
                        localOrStack.add(this.newStackMapType(label, 4));
                        localOrStack.add(this.newStackMapType(label, 0));
                        break;
                    }
                    case 10: {
                        StackMapType mapType = null;
                        String typeName = valueType.getInternalName();
                        if (typeName.equals("null")) {
                            mapType = this.newStackMapType(label, 5);
                        } else {
                            mapType = this.newStackMapType(label, 7);
                            mapType.setObject(typeName);
                        }
                        localOrStack.add(mapType);
                        break;
                    }
                    case 9: {
                        StackMapType mapType = this.newStackMapType(label, 7);
                        mapType.setObject(valueType.toString());
                        localOrStack.add(mapType);
                    }
                }
            }
        }
    }

    private void copyTryCatchBlocks(MethodNode methodNode, Region region, List blocks) {
        for (TryCatchBlockNode tryCatch : blocks) {
            if (!this.shouldCopy(tryCatch)) continue;
            methodNode.visitTryCatchBlock(region.getMappedLabel(tryCatch.start), region.getMappedLabel(tryCatch.end), region.getMappedLabel(tryCatch.handler), tryCatch.type);
        }
    }

    private Map createLineNumberMap() {
        HashMap<Label, LineNumberNode> map = new HashMap<Label, LineNumberNode>();
        for (LineNumberNode lineNumber : this.srcMethod.lineNumbers) {
            map.put(lineNumber.start, lineNumber);
        }
        return map;
    }

    private Map createLocalVariableMap() {
        HashMap<Label, ArrayList<LocalVariableNode>> map = new HashMap<Label, ArrayList<LocalVariableNode>>();
        for (LocalVariableNode localVariable : this.srcMethod.localVariables) {
            ArrayList<LocalVariableNode> startList = (ArrayList<LocalVariableNode>)map.get(localVariable.start);
            if (startList == null) {
                startList = new ArrayList<LocalVariableNode>();
                map.put(localVariable.start, startList);
            }
            startList.add(localVariable);
        }
        return map;
    }

    private MethodNode copyMethodMetadata(MethodNode method) {
        String[] exceptions = method.exceptions.toArray(new String[method.exceptions.size()]);
        return new MethodNode(method.access, method.name, method.desc, method.signature, exceptions);
    }

    private void copyRegion(MethodNode method, Region region) throws AnalyzerException {
        region.enter(method);
        int index = region.startIndex;
        while (index < region.endIndex) {
            AbstractInsnNode insnNode = this.getInstruction(this.srcMethod, index);
            if (insnNode.getType() == 7) {
                Label label = ((LabelNode)insnNode).label;
                this.visitLabel(method, region, label);
                if (this.isSubroutineStart(label)) {
                    Subroutine subroutine = (Subroutine)this.subroutineMap.get(label);
                    index = subroutine.endIndex;
                }
            } else if (!region.isSubroutineReturnStore(this.srcMethod, index)) {
                this.visitInstruction(method, region, insnNode);
            }
            ++index;
        }
        region.exit(method);
    }

    private StackMapFrame newStackMapFrame(Label label, Frame frame) throws AnalyzerException {
        ArrayList locals = new ArrayList();
        int localsCount = frame.getLocals();
        int i = 0;
        while (i < localsCount) {
            this.addStackMapType(locals, label, frame.getLocal(i));
            ++i;
        }
        this.removeTrailingTops(locals);
        ArrayList stack = new ArrayList();
        int stackCount = frame.getStackSize();
        int i2 = 0;
        while (i2 < stackCount) {
            this.addStackMapType(stack, label, frame.getStack(i2));
            ++i2;
        }
        this.removeTrailingTops(stack);
        return new StackMapFrame(label, locals, stack);
    }

    private StackMapType newStackMapType(Label label, int typeCode) {
        StackMapType type = StackMapType.getTypeInfo((int)typeCode);
        type.setLabel(label);
        return type;
    }

    private void removeTrailingTops(ArrayList localsOrStack) {
        while (this.removeTrailingTop(localsOrStack)) {
        }
    }

    private boolean removeTrailingTop(ArrayList localsOrStack) {
        int lastIndex;
        StackMapType type;
        boolean removed = false;
        if (localsOrStack.size() > 0 && (type = (StackMapType)localsOrStack.get(lastIndex = localsOrStack.size() - 1)).getType() == 0) {
            localsOrStack.remove(lastIndex);
            removed = true;
        }
        return removed;
    }

    private void createSubroutineMap() throws AnalyzerException {
        this.subroutineMap = new HashMap();
        HashSet<Label> subroutineStartLabels = new HashSet<Label>();
        for (Integer instructionIndex : this.srcMethod.getJsrInstructionIndices()) {
            JumpInsnNode jumpNode = (JumpInsnNode)this.getInstruction(this.srcMethod, instructionIndex);
            subroutineStartLabels.add(jumpNode.label);
        }
        if (subroutineStartLabels.size() > 0) {
            int i = 0;
            while (i < this.srcMethod.instructions.size()) {
                AbstractInsnNode insnNode = this.getInstruction(this.srcMethod, i);
                if (insnNode.getType() == 7) {
                    LabelNode labelNode = (LabelNode)insnNode;
                    if (subroutineStartLabels.contains(labelNode.label)) {
                        i = this.captureSubroutine(subroutineStartLabels, this.subroutineMap, i, this.srcMethod, (LabelNode)insnNode);
                    }
                }
                ++i;
            }
        }
    }

    private int captureSubroutine(Set subroutineStartLabels, Map subroutineMap, int index, MethodNode method, LabelNode labelNode) {
        AbstractInsnNode insn;
        Subroutine subroutine = new Subroutine(labelNode.label);
        subroutine.endIndex = subroutine.startIndex = index + 1;
        while (true) {
            if ((insn = this.getInstruction(method, subroutine.endIndex)).getType() == 7) {
                Label label = ((LabelNode)insn).label;
                if (subroutineStartLabels.contains(label)) {
                    subroutine.endIndex = this.captureSubroutine(subroutineStartLabels, subroutineMap, subroutine.endIndex, this.srcMethod, (LabelNode)insn);
                } else {
                    subroutine.addLabel(label);
                }
            } else if (insn.getOpcode() == 169) break;
            ++subroutine.endIndex;
        }
        VarInsnNode varInsnNode = (VarInsnNode)insn;
        int variableNumber = varInsnNode.var;
        subroutine.setReturnVariable(variableNumber);
        Label label = labelNode.label;
        if (!subroutineMap.containsKey(label)) {
            subroutineMap.put(label, subroutine);
        }
        return subroutine.endIndex + 1;
    }

    private boolean shouldCopy(TryCatchBlockNode tryCatch) {
        boolean shouldCopy = true;
        int startIndex = this.getLabelIndex(this.srcMethod, tryCatch.start);
        ArrayList<AbstractInsnNode> insns = new ArrayList<AbstractInsnNode>();
        int i = startIndex;
        while (i < this.srcMethod.instructions.size()) {
            AbstractInsnNode insn = this.getInstruction(this.srcMethod, i);
            if (insn.getType() == 7) {
                LabelNode l = (LabelNode)insn;
                if (l.label.equals(tryCatch.end)) {
                    break;
                }
            } else {
                insns.add(insn);
            }
            ++i;
        }
        if (insns.size() == 1) {
            AbstractInsnNode insn = (AbstractInsnNode)insns.get(0);
            shouldCopy = insn.getOpcode() != 168;
        }
        return shouldCopy;
    }

    private boolean shouldReduceVariableVisibility(MethodNode method) {
        List instructions;
        int instructionCount;
        AbstractInsnNode node;
        boolean shouldReduce = false;
        if (this.getLastInstruction(method) instanceof LabelNode && (node = this.getInstruction(method, (instructionCount = (instructions = this.updatedMethod.instructions).size()) - 2)) instanceof InsnNode) {
            InsnNode insnNode = (InsnNode)node;
            switch (insnNode.getOpcode()) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    shouldReduce = true;
                }
            }
        }
        return shouldReduce;
    }

    private void sortTryCatchBlocks(Region methodRegion) {
        Iterator blocks = this.srcMethod.tryCatchBlocks.iterator();
        while (blocks.hasNext()) {
            Region enclosingRegion = methodRegion;
            TryCatchBlockNode block = (TryCatchBlockNode)blocks.next();
            for (Region region : this.subroutineMap.values()) {
                if (!region.encloses(block)) continue;
                if (enclosingRegion == null) {
                    enclosingRegion = region;
                    continue;
                }
                if (region.getLength() >= enclosingRegion.getLength()) continue;
                enclosingRegion = region;
            }
            enclosingRegion.addTryCatchBlock(block);
        }
    }

    private Set findTargetLabels() {
        HashSet<Label> targetLabels = new HashSet<Label>();
        for (AbstractInsnNode insnNode : this.updatedMethod.instructions) {
            switch (insnNode.getType()) {
                case 6: {
                    JumpInsnNode jumpInsnNode = (JumpInsnNode)insnNode;
                    targetLabels.add(jumpInsnNode.label);
                    break;
                }
                case 11: {
                    LookupSwitchInsnNode lookupSwitchNode = (LookupSwitchInsnNode)insnNode;
                    for (Label label : lookupSwitchNode.labels) {
                        targetLabels.add(label);
                    }
                    targetLabels.add(lookupSwitchNode.dflt);
                    break;
                }
                case 10: {
                    TableSwitchInsnNode tableSwitchNode = (TableSwitchInsnNode)insnNode;
                    for (Label label : tableSwitchNode.labels) {
                        targetLabels.add(label);
                    }
                    targetLabels.add(tableSwitchNode.dflt);
                }
            }
        }
        for (TryCatchBlockNode tryCatchBlock : this.updatedMethod.tryCatchBlocks) {
            targetLabels.add(tryCatchBlock.handler);
        }
        return targetLabels;
    }

    private AbstractInsnNode getInstruction(MethodNode method, int index) {
        List instructions = method.instructions;
        return index < instructions.size() ? instructions.get(index) : null;
    }

    private int getLabelIndex(PreverifierMethodNode methodNode, Label label) {
        Integer i = (Integer)methodNode.getLabelIndices().get(label);
        return i;
    }

    private AbstractInsnNode getLastInstruction(MethodNode method) {
        return this.getInstruction(method, method.instructions.size() - 1);
    }

    private Label[] getMappedLabelArray(Region region, List labels) {
        Label[] mappedLabels = new Label[labels.size()];
        int i = 0;
        while (i < mappedLabels.length) {
            mappedLabels[i] = region.getMappedLabel((Label)labels.get(i));
            ++i;
        }
        return mappedLabels;
    }

    private boolean isSubroutineStart(Label label) {
        return this.subroutineMap.containsKey(label);
    }

    private void visitInstruction(MethodNode method, Region region, AbstractInsnNode insnNode) throws AnalyzerException {
        int opcode = insnNode.getOpcode();
        switch (opcode) {
            case 168: {
                this.visitJumpToSubroutine(method, region, (JumpInsnNode)insnNode);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 198: 
            case 199: {
                this.visitJump(method, region, (JumpInsnNode)insnNode);
                break;
            }
            case 171: {
                this.visitLookupSwitch(method, region, (LookupSwitchInsnNode)insnNode);
                break;
            }
            case 170: {
                this.visitTableSwitch(method, region, (TableSwitchInsnNode)insnNode);
                break;
            }
            default: {
                insnNode.accept((MethodVisitor)method);
            }
        }
    }

    private void visitJump(MethodNode method, Region region, JumpInsnNode jumpNode) {
        Label mappedLabel = region.getMappedLabel(jumpNode.label);
        JumpInsnNode newJumpNode = new JumpInsnNode(jumpNode.getOpcode(), mappedLabel);
        newJumpNode.accept((MethodVisitor)method);
    }

    private void visitJumpToSubroutine(MethodNode method, Region region, JumpInsnNode jumpNode) throws AnalyzerException {
        List instructions;
        AbstractInsnNode insnNode2;
        AbstractInsnNode insnNode = this.getLastInstruction(this.updatedMethod);
        if (insnNode instanceof VarInsnNode && (insnNode2 = (AbstractInsnNode)(instructions = this.updatedMethod.instructions).get(instructions.size() - 2)) instanceof LabelNode) {
            LabelNode labelNode = (LabelNode)insnNode2;
            ArrayList localVariables = (ArrayList)this.localVariableByEndLabelMap.get(labelNode.label);
            if (localVariables != null) {
                for (LocalVariableNode var : localVariables) {
                    var.end = new Label();
                    method.visitLabel(var.end);
                }
            }
        }
        Subroutine subroutine = (Subroutine)this.subroutineMap.get(jumpNode.label);
        subroutine.setParentRegion(region);
        this.copyRegion(method, subroutine);
    }

    private void visitLabel(MethodNode method, Region region, Label label) {
        ArrayList localVariables;
        Label mappedLabel = region.getMappedLabel(label);
        method.visitLabel(mappedLabel);
        LineNumberNode lineNumber = (LineNumberNode)this.lineNumberMap.get(label);
        if (lineNumber != null) {
            method.visitLineNumber(lineNumber.line, mappedLabel);
        }
        if ((localVariables = (ArrayList)this.localVariableByStartLabelMap.get(label)) != null) {
            Iterator vars = localVariables.iterator();
            while (vars.hasNext()) {
                int localVariableCount = method.localVariables.size();
                LocalVariableNode localVariable = (LocalVariableNode)vars.next();
                method.visitLocalVariable(localVariable.name, localVariable.desc, localVariable.signature, region.getMappedLabel(localVariable.start), region.getMappedLabel(localVariable.end), localVariable.index);
                LocalVariableNode newLocalVariable = (LocalVariableNode)method.localVariables.get(localVariableCount);
                this.addNewLocalVariableByEnd(newLocalVariable);
            }
        }
    }

    private void visitLookupSwitch(MethodNode codeVisitor, Region region, LookupSwitchInsnNode node) {
        Label dflt = region.getMappedLabel(node.dflt);
        int[] keys = new int[node.keys.size()];
        int i = 0;
        while (i < keys.length) {
            keys[i] = (Integer)node.keys.get(i);
            ++i;
        }
        Label[] labels = this.getMappedLabelArray(region, node.labels);
        LookupSwitchInsnNode newSwitch = new LookupSwitchInsnNode(dflt, keys, labels);
        newSwitch.accept((MethodVisitor)codeVisitor);
    }

    private void visitTableSwitch(MethodNode codeVisitor, Region region, TableSwitchInsnNode node) {
        Label dflt = region.getMappedLabel(node.dflt);
        Label[] labels = this.getMappedLabelArray(region, node.labels);
        TableSwitchInsnNode newSwitch = new TableSwitchInsnNode(node.min, node.max, dflt, labels);
        newSwitch.accept((MethodVisitor)codeVisitor);
    }

    public class MappedLabel
    extends Label {
        private Label originalLabel;

        public MappedLabel(Label label) {
            this.originalLabel = label;
        }

        public Label getOriginalLabel() {
            return this.originalLabel;
        }

        public String toString() {
            return String.valueOf(this.originalLabel.toString()) + " -> " + super.toString();
        }
    }

    class Region {
        protected Region parentRegion;
        protected int startIndex;
        protected int endIndex;
        protected Map labelMap;
        protected Set labels;
        protected List tryCatchBlocks;

        Region() {
            this(0, 0);
        }

        Region(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.labelMap = new HashMap();
            this.labels = new HashSet();
            this.tryCatchBlocks = new ArrayList();
        }

        void addLabel(Label label) {
            this.labels.add(label);
        }

        void addTryCatchBlock(TryCatchBlockNode tryCatchBlock) {
            this.tryCatchBlocks.add(tryCatchBlock);
        }

        boolean encloses(TryCatchBlockNode tryCatchBlock) {
            return this.labels.contains(tryCatchBlock.start) && this.labels.contains(tryCatchBlock.end);
        }

        void enter(MethodNode method) {
            this.labelMap.clear();
            MethodRewriter.this.copyTryCatchBlocks(method, this, this.tryCatchBlocks);
        }

        void exit(MethodNode method) {
        }

        int getLength() {
            return this.endIndex - this.startIndex;
        }

        Label getMappedLabel(Label originalLabel) {
            Label mappedLabel = this.findMappedLabel(originalLabel);
            if (mappedLabel == null) {
                mappedLabel = new MappedLabel(originalLabel);
                Map map = this.findLabelMap(originalLabel);
                map.put(originalLabel, mappedLabel);
            }
            return mappedLabel;
        }

        boolean isSubroutineReturnStore(MethodNode methodNode, int index) {
            return false;
        }

        void setParentRegion(Region parentRegion) {
            this.parentRegion = parentRegion;
        }

        protected Map findLabelMap(Label originalLabel) {
            Map map = this.findLabelMapRecursive(originalLabel);
            return map != null ? map : this.labelMap;
        }

        protected Map findLabelMapRecursive(Label originalLabel) {
            Map map = null;
            if (this.labels.contains(originalLabel)) {
                map = this.labelMap;
            } else if (this.parentRegion != null) {
                map = this.parentRegion.findLabelMapRecursive(originalLabel);
            }
            return map;
        }

        protected Label findMappedLabel(Label originalLabel) {
            Label mappedLabel = (Label)this.labelMap.get(originalLabel);
            if (mappedLabel == null && this.parentRegion != null) {
                mappedLabel = this.parentRegion.findMappedLabel(originalLabel);
            }
            return mappedLabel;
        }

        List getTryCatchBlocks() {
            return this.tryCatchBlocks;
        }
    }

    class Subroutine
    extends Region {
        Label label;
        int returnVariable;

        Subroutine(Label label) {
            this.label = label;
        }

        public int getReturnVariable() {
            return this.returnVariable;
        }

        boolean isSubroutineReturnStore(MethodNode methodNode, int index) {
            boolean isReturnStore = false;
            AbstractInsnNode insnNode = MethodRewriter.this.getInstruction(methodNode, index);
            if (insnNode.getOpcode() == 58) {
                VarInsnNode varInsnNode = (VarInsnNode)insnNode;
                isReturnStore = varInsnNode.var == this.returnVariable;
            }
            return isReturnStore;
        }

        public void setReturnVariable(int returnVariable) {
            this.returnVariable = returnVariable;
        }
    }
}

