/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.action;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.BuildManagement;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.util.EclipseUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.action.AbstractJavaProjectAction;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ToggleProjectBuildAction
extends AbstractJavaProjectAction {
    private IStructuredSelection currentProjectSelection = null;
    IMtjProject mtjproject;
    BuildManagement buildManagement;
    RuntimePlatformDefinition rpd;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    private IProject findProject(IProject project) throws CoreException {
        IProject[] projects = EclipseUtil.getProjectsForNature((String)MtjNature.getNatureID());
        int i = 0;
        while (i < projects.length) {
            if (projects[i] == project) {
                return projects[i];
            }
            ++i;
        }
        MessageDialog.openInformation((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectBuildAction_InformationDialogTitle, (String)Messages.ToggleProjectBuildAction_ProjectNotMtj);
        return null;
    }

    private IProject getProject() {
        if (this.currentProjectSelection.getFirstElement() instanceof IJavaProject) {
            return ((IJavaProject)this.currentProjectSelection.getFirstElement()).getProject();
        }
        return (IProject)this.currentProjectSelection.getFirstElement();
    }

    private void openMtjExceptionDialog(MtjException e) {
        ErrorDialog.openError((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectBuildAction_Error_while_building_project, (String)e.getMessage(), (IStatus)new Status(4, "org.eclipse.mtj.core.ui", -1, e.toString(), (Throwable)e));
    }

    private void openCoreExceptionDialog(CoreException e) {
        ErrorDialog.openError((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectBuildAction_Error, (String)this.getClass().getName(), (IStatus)e.getStatus());
    }

    private void processProjectData(IProject project, BuildManagement bm) throws MtjException {
        IMtjProject proj = MtjProject.getMtjProject(project);
        Project data = proj.getProjectData();
        if (data == null || data.getDefaultTargetDevice() == null || data.getDefaultTargetDevice().getRuntimePlatform() == null) {
            MessageDialog.openInformation((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectBuildAction_Error_while_building_project_2, (String)Messages.ToggleProjectBuildAction_Project_default_target_device_not_selected);
        } else {
            this.rpd = data.getDefaultTargetDevice().getRuntimePlatform();
            this.mtjproject = MtjProject.getMtjProject(project);
            this.buildManagement = bm;
            try {
                IWorkbench wb = PlatformUI.getWorkbench();
                IProgressService ps = wb.getProgressService();
                ps.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InvocationTargetException {
                        try {
                            ToggleProjectBuildAction.this.build(pm);
                        }
                        catch (MtjException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw (MtjException)e.getTargetException();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (SWTException sWTException) {
                this.build((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public void build(IProgressMonitor pm) throws MtjException {
        this.buildManagement.build(this.mtjproject, MtjNature.getNatureID(), BuildType.BUILD_TYPE_ECLIPSE_LITERAL, this.rpd, pm);
    }

    public void run(ILaunchConfiguration launchConfiguration) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
            if (project != null) {
                BuildManagement bm = (BuildManagement)MtjServices.getInstance().getImplementations(ExtensionType.BUILD_MANAGEMENT_LITERAL, null, null, true)[0];
                this.processProjectData(project, bm);
            }
        }
        catch (MtjException e) {
            this.openMtjExceptionDialog(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(IAction action) {
        try {
            IProject project = this.findProject(this.getProject());
            if (project != null) {
                BuildManagement bm = (BuildManagement)MtjServices.getInstance().getImplementations(ExtensionType.BUILD_MANAGEMENT_LITERAL, null, null, true)[0];
                this.processProjectData(project, bm);
            }
        }
        catch (MtjException e) {
            this.openMtjExceptionDialog(e);
        }
        catch (CoreException ce) {
            this.openCoreExceptionDialog(ce);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.currentProjectSelection = (IStructuredSelection)selection;
        }
    }
}

