/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.action;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.util.EclipseUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ToggleProjectNatureAction
implements IWorkbenchWindowActionDelegate {
    private IStructuredSelection currentProjectSelection = null;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        IProject project = this.currentProjectSelection.getFirstElement() instanceof IJavaProject ? ((IJavaProject)this.currentProjectSelection.getFirstElement()).getProject() : (IProject)this.currentProjectSelection.getFirstElement();
        try {
            IProject[] projects = EclipseUtil.getProjectsForNature((String)MtjNature.getNatureID());
            int ix = -1;
            int i = 0;
            while (i < projects.length) {
                if (projects[i] == project) {
                    ix = i;
                    break;
                }
                ++i;
            }
            if (ix == -1) {
                EclipseUtil.toggleProjectNature((String)MtjNature.getNatureID(), (IProject)project);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                javaProject.setOption("org.eclipse.jdt.core.compiler.compliance", "1.4");
                javaProject.setOption("org.eclipse.jdt.core.compiler.source", "1.3");
                javaProject.setOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                Project mtjProject = ProjectFactory.eINSTANCE.createProject();
                mtjProject.setType(ProjectType.PROJECT_TYPE_MIDP_LITERAL);
                try {
                    MtjProject.setProjectData(javaProject, mtjProject);
                }
                catch (MtjException e) {
                    e.printStackTrace();
                }
            } else {
                MessageDialog.openInformation((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectNatureAction_InformationDialogTitle, (String)Messages.ToggleProjectNatureAction_Project_alread_MTJ_project);
            }
        }
        catch (CoreException ce) {
            ErrorDialog.openError((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectNatureAction_Error, (String)this.getClass().getName(), (IStatus)ce.getStatus());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.currentProjectSelection = (IStructuredSelection)selection;
        }
    }
}

