/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.executable;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.extension.devide.utils.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.internal.utils.Utils;

public class ClasspathCollectionVisitor
extends FilteringClasspathEntryVisitor {
    private Set cpEntries;
    private IPath classesPath;
    private IPath libsPath;

    public ClasspathCollectionVisitor(IPath classesPath, IPath libsPath) {
        this.classesPath = classesPath;
        this.libsPath = libsPath;
        this.cpEntries = new LinkedHashSet();
    }

    public Set getCpEntries() {
        return this.cpEntries;
    }

    public void visitLibraryEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        File resolvedEntry = Utils.getResolvedClasspathEntryFile((IClasspathEntry)entry);
        if (resolvedEntry.isFile()) {
            IPath libPath = this.libsPath.append(entry.getPath().lastSegment());
            this.cpEntries.add(libPath);
        }
    }

    public void visitSourceEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        this.cpEntries.add(this.classesPath);
    }
}

