/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.devide.ui.wizard.projectcreation.MTJNewProjectSelectLibraryWizardPage;

public class MTJLibrarySelectionWizard
extends Wizard {
    private IStructuredSelection selected;
    IProject project;
    MTJNewProjectSelectLibraryWizardPage libraryWizardPage;

    public MTJLibrarySelectionWizard(IStructuredSelection selected) {
        this.selected = selected;
        Object ob = selected.getFirstElement();
        if (ob instanceof IProject) {
            this.project = (IProject)ob;
        }
        if (ob instanceof IFile) {
            IFile projectResource = (IFile)ob;
            this.project = projectResource.getProject();
        }
    }

    public IStructuredSelection getSelected() {
        return this.selected;
    }

    public void addPages() {
        this.libraryWizardPage = new MTJNewProjectSelectLibraryWizardPage("", this.project);
        this.addPage((IWizardPage)this.libraryWizardPage);
    }

    public boolean performFinish() {
        NullProgressMonitor pm = new NullProgressMonitor();
        TargetDevice[] projectModelData = this.libraryWizardPage.getProjectModelData();
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        try {
            MtjProject mtjProject = (MtjProject)MtjProject.getMtjProject(javaProject);
            Project model = mtjProject.getProjectData();
            model.setDefaultTargetDevice(projectModelData[0]);
            mtjProject.setProjectData(model);
            mtjProject.addClasspathContainerIfMissing((IProgressMonitor)pm);
        }
        catch (MtjException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }
}

