/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.jadeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.extension.devide.jadeditor.AbstractJADEditorPage;
import org.eclipse.mtj.extension.devide.jadeditor.JADEditor;
import org.eclipse.mtj.extension.devide.jadeditor.JadEditorStrings;
import org.eclipse.mtj.extension.devide.jadeditor.ManifestPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JADUserDefinedPropertiesEditorPage
extends AbstractJADEditorPage {
    private static final String PROP_KEY = "key";
    private static final String PROP_VALUE = "value";
    private static final String[] PROPERTIES = new String[]{"key", "value"};
    private static final List PROPERTY_LIST = Arrays.asList(PROPERTIES);
    private List userDefinedProperties = new ArrayList();
    private TableViewer tableViewer;
    private Button removeButton;
    private Button addButton;

    public JADUserDefinedPropertiesEditorPage(JADEditor editor, String title) {
        super(editor, "user_defined", title);
    }

    public void doSave(IProgressMonitor monitor) {
        ManifestPreferenceStore store = this.getPreferenceStore();
        for (KeyValuePair entry : this.userDefinedProperties) {
            store.setValue(entry.fields[0], entry.fields[1]);
        }
        this.setDirty(false);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = this.createSectionComposite(managedForm);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(2, false));
        new Label(parent, 0);
        new Label(parent, 0);
        this.createTableViewer(toolkit, parent);
        this.createButtons(toolkit, parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "eclipseme.ui.help_JADUserDefinedPropertiesEditorPage");
    }

    protected String getSectionTitle() {
        return "User Defined Properties";
    }

    protected String getSectionDescription() {
        return "User Defined properties may be specified on this page";
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)input);
        }
        this.updateMidletProperties();
    }

    void editorInputChanged() {
        this.updateMidletProperties();
    }

    private void addItem() {
        KeyValuePair keyValuePair = new KeyValuePair("New Key", "New Value");
        this.userDefinedProperties.add(keyValuePair);
        this.tableViewer.refresh();
        this.setDirty(true);
    }

    private void createButtons(FormToolkit toolkit, Composite parent) {
        Composite composite = toolkit.createComposite(parent);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        composite.setLayout((Layout)layout);
        this.addButton = toolkit.createButton(composite, JadEditorStrings.editor_button_add, 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADUserDefinedPropertiesEditorPage.this.addItem();
            }
        });
        toolkit.createLabel(composite, "");
        this.removeButton = toolkit.createButton(composite, JadEditorStrings.editor_button_remove, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADUserDefinedPropertiesEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(FormToolkit toolkit, Composite parent) {
        String[] columns = new String[]{JadEditorStrings.property_jad_userdef_key, JadEditorStrings.property_jad_userdef_value};
        int styles = 68356;
        Table table = toolkit.createTable(parent, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected = (TableItem)e.item;
                JADUserDefinedPropertiesEditorPage.this.removeButton.setEnabled(selected.getParent().getSelectionCount() > 0);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableLayout layout = new TableLayout();
        int width = 100 / columns.length;
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(width));
            ++i;
        }
        table.setLayout((Layout)layout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.tableViewer.setColumnProperties(PROPERTIES);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private boolean isUserDefinedPropertyKey(String key) {
        JADEditor jadEditor = (JADEditor)this.getEditor();
        return jadEditor.isUserDefinedPropertyKey(key);
    }

    private void removeSelectedItems() {
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        int i = indices.length;
        while (i > 0) {
            int index = indices[i - 1];
            KeyValuePair keyValuePair = (KeyValuePair)this.userDefinedProperties.remove(index);
            this.getPreferenceStore().setToDefault(keyValuePair.fields[0]);
            --i;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    private void updateMidletProperties() {
        this.userDefinedProperties.clear();
        ManifestPreferenceStore store = this.getPreferenceStore();
        String[] names = store.preferenceNames();
        int i = 0;
        while (i < names.length) {
            String propName = names[i];
            if (this.isUserDefinedPropertyKey(propName)) {
                this.userDefinedProperties.add(new KeyValuePair(propName, store.getString(propName)));
            }
            ++i;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String value = null;
            if (element instanceof KeyValuePair) {
                KeyValuePair pair = (KeyValuePair)element;
                int fieldIndex = this.getFieldIndex(property);
                if (fieldIndex != -1) {
                    value = pair.fields[fieldIndex];
                }
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                Object data = ((TableItem)element).getData();
                String newValue = (String)value;
                if (data instanceof KeyValuePair) {
                    int fieldIndex = this.getFieldIndex(property);
                    KeyValuePair pair = (KeyValuePair)data;
                    if (fieldIndex != -1) {
                        this.updateField(pair, property, fieldIndex, newValue);
                    }
                }
            }
        }

        private int getFieldIndex(String property) {
            return PROPERTY_LIST.indexOf(property);
        }

        private void updateField(KeyValuePair pair, String property, int fieldIndex, String newValue) {
            if (!pair.fields[fieldIndex].equals(newValue)) {
                pair.fields[fieldIndex] = newValue;
                JADUserDefinedPropertiesEditorPage.this.setDirty(true);
                JADUserDefinedPropertiesEditorPage.this.tableViewer.update((Object)pair, new String[]{property});
            }
        }
    }

    private class KeyValuePair {
        String[] fields;

        KeyValuePair(String key, String value) {
            this.fields = new String[]{key, value};
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.toArray(new Object[JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            KeyValuePair pair = (KeyValuePair)element;
            return pair.fields[columnIndex];
        }
    }
}

