/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.pp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.PackagingProvider;
import org.eclipse.mtj.api.extension.impl.BuildExtensionImpl;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.packaging.MidpPackagingResources;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.devide.utils.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.extension.devide.utils.IClasspathEntryVisitor;
import org.eclipse.mtj.extension.pp.Messages;
import org.eclipse.mtj.internal.utils.EntryTrackingJarOutputStream;
import org.eclipse.mtj.internal.utils.Utils;

public class JavaMePackagingProviderImpl
extends BuildExtensionImpl
implements PackagingProvider {
    public static final String EXT_JAR_NAME = "packager.jar";
    public static final String RESOURCE_DIRECTORY_NAME = "res";
    private Properties midletProperties;

    public JavaMePackagingProviderImpl() {
        this.setId("org.eclipse.mtj.extension.pp.CDC");
        this.setDescription(Messages.JavaMePackagingProviderImpl_PluginDescription);
        this.setVendor(Messages.JavaMePackagingProviderImpl_PluginVendor);
        this.setVersion(Messages.JavaMePackagingProviderImpl_PluginVersion);
        this.setType(ExtensionType.PACKAGING_PROVIDER_LITERAL);
        this.setExtJar(EXT_JAR_NAME);
    }

    public DeploymentType[] getSupportedTypes() throws MtjException {
        DeploymentType[] ret = new DeploymentType[]{DeploymentType.DEPLOYMENT_TYPE_CDC_LITERAL};
        return ret;
    }

    public void setMidletProperties(Properties midletProperties) {
        this.midletProperties = midletProperties;
    }

    public Deployment createDeployment(String projectName, Project projectData, IResource[] resources, IFolder deploymentFolder, DeploymentType type, String natureId, IProgressMonitor monitor) throws MtjException {
        try {
            IFolder projectFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation());
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(projectName);
            IMtjProject mtjProject = null;
            try {
                mtjProject = MtjProject.getMtjProject((IProject)project);
            }
            catch (MtjException mtjException) {}
            IFile finalJarFile = this.getJarFile(projectName, deploymentFolder, "");
            if (finalJarFile.exists()) {
                finalJarFile.delete(true, monitor);
            }
            MidpPackagingResources midpPackagingResources = new MidpPackagingResources(resources);
            IFolder verifiedClassesOutputFolder = midpPackagingResources.getVerifiedClassesOutputFolder();
            IFolder verifiedLibrariesOutputFolder = midpPackagingResources.getVerifiedLibrariesOutputFolder();
            IFolder resourcesFolder = null;
            if (mtjProject != null) {
                resourcesFolder = mtjProject.getFolder(RESOURCE_DIRECTORY_NAME, monitor);
            }
            this.createDeployedJarFile(projectName, projectData, verifiedClassesOutputFolder, verifiedLibrariesOutputFolder, resourcesFolder, monitor, deploymentFolder, projectFolder, natureId);
            deploymentFolder.refreshLocal(1, monitor);
            return null;
        }
        catch (CoreException ex) {
            throw new MtjException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new MtjException((Throwable)ex);
        }
    }

    private IFile getJarFile(String projectName, IFolder deploymentFolder, String extension) {
        String jarFileName = String.valueOf(projectName.replace(' ', '_')) + extension + ".jar";
        return deploymentFolder.getFile(jarFileName);
    }

    private File createDeployedJarFile(String projectName, Project projectData, IFolder verifiedLibrariesOutputFolder, IFolder verifiedClassesOutputFolder, IFolder resourcesFolder, IProgressMonitor monitor, IFolder deploymentFolder, IFolder projectFolder, String natureId) throws CoreException, IOException {
        IFile jarIFile = this.getJarFile(projectName, deploymentFolder, "");
        File jarFile = this.resourceToFile((IResource)jarIFile);
        FileOutputStream fos = new FileOutputStream(jarFile);
        EntryTrackingJarOutputStream jarOutputStream = new EntryTrackingJarOutputStream((OutputStream)fos);
        try {
            MtjProject.getMtjProject((String)projectName);
            this.addVerifiedClasspathContentsToJar(jarOutputStream, projectName, verifiedLibrariesOutputFolder, verifiedClassesOutputFolder, natureId, monitor);
        }
        catch (MtjException mtjException) {}
        if (resourcesFolder != null) {
            this.addFilteredResourcesToJar(jarOutputStream, new IncludeAllResourceFilter(), resourcesFolder.getFullPath(), (IContainer)resourcesFolder);
        }
        jarOutputStream.close();
        return this.resourceToFile((IResource)this.getJarFile(projectName, deploymentFolder, ""));
    }

    private void addVerifiedClasspathContentsToJar(EntryTrackingJarOutputStream jarOutputStream, String projectName, IFolder verifiedLibrariesOutputFolder, IFolder verifiedClassesOutputFolder, String natureId, IProgressMonitor monitor) throws CoreException, IOException {
        IJavaProject javaProject = this.getJavaProject(projectName);
        PackagerClasspathEntryVisitor visitor = new PackagerClasspathEntryVisitor(jarOutputStream, verifiedLibrariesOutputFolder, verifiedClassesOutputFolder);
        visitor.getRunner().run(javaProject, (IClasspathEntryVisitor)visitor, natureId, monitor);
    }

    private IJavaProject getJavaProject(String projectName) {
        return JavaCore.create((IProject)this.getProject(projectName));
    }

    private IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private File resourceToFile(IResource resource) {
        return new File(resource.getLocation().toOSString());
    }

    private void addFilteredResourcesToJar(EntryTrackingJarOutputStream jarOutputStream, IResourceFilter resourceFilter, IPath rootPath, IContainer container) throws CoreException, IOException {
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (resource instanceof IContainer) {
                IContainer cont = (IContainer)resource;
                if (resourceFilter.shouldTraverseContainer(cont)) {
                    this.addFilteredResourcesToJar(jarOutputStream, resourceFilter, rootPath, cont);
                }
            } else if (resource.getType() == 1 && resourceFilter.shouldBeIncluded((IFile)resource)) {
                this.addResourceToJar(jarOutputStream, rootPath, resource);
            }
            ++i;
        }
    }

    private void addResourceToJar(EntryTrackingJarOutputStream jarOutputStream, IPath rootPath, IResource resource) throws IOException {
        IPath resourcePath = resource.getFullPath();
        int commonSegments = resourcePath.matchingFirstSegments(rootPath);
        IPath entryPath = resourcePath.removeFirstSegments(commonSegments);
        File file = new File(resource.getLocation().toOSString());
        this.addFileToJar(jarOutputStream, entryPath.toString(), file);
    }

    private void addFileToJar(EntryTrackingJarOutputStream jarOutputStream, String entryName, File file) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setSize(file.length());
        entry.setTime(file.lastModified());
        this.createJarEntry(jarOutputStream, entry, new FileInputStream(file));
    }

    private void createJarEntry(EntryTrackingJarOutputStream jarOutputStream, ZipEntry zipEntry, InputStream is) throws IOException {
        ZipEntry newEntry = new ZipEntry(zipEntry.getName());
        newEntry.setTime(zipEntry.getTime());
        if (zipEntry.getComment() != null) {
            newEntry.setComment(zipEntry.getComment());
        }
        if (zipEntry.getExtra() != null) {
            newEntry.setExtra(zipEntry.getExtra());
        }
        if (!jarOutputStream.alreadyAdded(zipEntry)) {
            jarOutputStream.putNextEntry(newEntry);
            Utils.copyInputToOutput((InputStream)is, (OutputStream)jarOutputStream);
            jarOutputStream.closeEntry();
        }
    }

    private class PackagerClasspathEntryVisitor
    extends FilteringClasspathEntryVisitor {
        private EntryTrackingJarOutputStream jarStream;
        private boolean visitedSource;
        private IFolder verifiedLibrariesOutputFolder;
        private IFolder verifiedClassesOutputFolder;

        private PackagerClasspathEntryVisitor(EntryTrackingJarOutputStream jarStream, IFolder verifiedClassesOutputFolder, IFolder verifiedLibrariesOutputFolder) {
            this.jarStream = jarStream;
            this.verifiedLibrariesOutputFolder = verifiedLibrariesOutputFolder;
            this.verifiedClassesOutputFolder = verifiedClassesOutputFolder;
            this.visitedSource = false;
        }

        public void visitLibraryEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
            IFile lib;
            File entryFile = Utils.getResolvedClasspathEntryFile((IClasspathEntry)entry);
            if (entryFile != null && entryFile.isFile() && (lib = this.verifiedLibrariesOutputFolder.getFile(entry.getPath().lastSegment())).exists()) {
                try {
                    this.copyLibContentsToJar(this.jarStream, lib, monitor);
                }
                catch (IOException e) {
                    MtjCorePlugin.throwCoreException((int)4, (int)-999, (Throwable)e);
                }
            }
        }

        public void visitSourceEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
            if (!this.visitedSource) {
                this.visitedSource = true;
                try {
                    JavaMePackagingProviderImpl.this.addFilteredResourcesToJar(this.jarStream, new IncludeAllResourceFilter(), this.verifiedClassesOutputFolder.getFullPath(), (IContainer)this.verifiedClassesOutputFolder);
                }
                catch (IOException e) {
                    MtjCorePlugin.throwCoreException((int)4, (int)-999, (Throwable)e);
                }
            }
        }

        private void copyLibContentsToJar(EntryTrackingJarOutputStream jarOutputStream, IFile lib, IProgressMonitor monitor) throws IOException {
            File libFile = lib.getLocation().toFile();
            ZipInputStream zis = new ZipInputStream(new FileInputStream(libFile));
            ZipEntry zipEntry = null;
            do {
                if ((zipEntry = zis.getNextEntry()) == null) continue;
                JavaMePackagingProviderImpl.this.createJarEntry(jarOutputStream, zipEntry, zis);
            } while (zipEntry != null);
            zis.close();
        }
    }

    private class IncludeAllResourceFilter
    implements IResourceFilter {
        private IncludeAllResourceFilter() {
        }

        public boolean shouldTraverseContainer(IContainer container) {
            return true;
        }

        public boolean shouldBeIncluded(IFile file) {
            return true;
        }
    }

    public static interface IResourceFilter {
        public boolean shouldTraverseContainer(IContainer var1);

        public boolean shouldBeIncluded(IFile var1);
    }
}

