/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.ui.util;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;

public class DevicePlatformImportContentProvider
implements ITreeContentProvider {
    private DevicePlatform[] myContents;
    private Viewer myViewer;
    private Hashtable dpAndDevices;

    public DevicePlatformImportContentProvider(Viewer viewer) {
        this.myViewer = viewer;
        this.dpAndDevices = new Hashtable();
    }

    public Object[] getChildren(Object parentElement) {
        Vector l = new Vector();
        if (parentElement instanceof DevicePlatform) {
            DevicePlatform dp = (DevicePlatform)parentElement;
            l.addAll(dp.getDevices());
            return l.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof Device) {
            return this.dpAndDevices.get(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof DevicePlatform;
    }

    public Object[] getElements(Object inputElement) {
        return this.myContents;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
        if (newInput instanceof DevicePlatform[]) {
            DevicePlatform[] inputArray = (DevicePlatform[])newInput;
            this.myContents = new DevicePlatform[inputArray.length];
            System.arraycopy(inputArray, 0, this.myContents, 0, inputArray.length);
            this.updateDpAndDevices();
        } else if (newInput instanceof EList) {
            this.myContents = (DevicePlatform[])((EList)newInput).toArray();
            this.updateDpAndDevices();
        } else if (newInput == null) {
            this.myContents = null;
            this.dpAndDevices.clear();
        }
    }

    private void updateDpAndDevices() {
        this.dpAndDevices.clear();
        EList devices = null;
        int i = 0;
        while (i < this.myContents.length) {
            devices = this.myContents[i].getDevices();
            int j = 0;
            while (j < devices.size()) {
                this.dpAndDevices.put(devices.get(j), this.myContents[i]);
                ++j;
            }
            ++i;
        }
    }
}

