/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.api.model.preverifier;

import org.eclipse.mtj.api.model.preverifier.IClassErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IFieldErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IMethodErrorInformation;
import org.eclipse.mtj.api.model.preverifier.PreverificationErrorLocation;
import org.eclipse.mtj.api.model.preverifier.PreverificationErrorType;
import org.eclipse.mtj.core.Messages;

public class PreverificationError {
    private PreverificationErrorType errorType;
    private PreverificationErrorLocation errorLocation;
    private String detail;

    public PreverificationError(PreverificationErrorType type, PreverificationErrorLocation location, String detailMessage) {
        this.detail = detailMessage;
        this.errorLocation = location;
        this.errorType = type;
    }

    public String getDetail() {
        return this.detail;
    }

    public PreverificationErrorLocation getLocation() {
        return this.errorLocation;
    }

    public PreverificationErrorType getType() {
        return this.errorType;
    }

    public String getErrorText() {
        StringBuffer errorText = new StringBuffer();
        String detail = this.getDetail();
        if (detail != null && detail.length() > 0) {
            errorText.append(detail);
        } else {
            this.appendErrorInformation(errorText);
        }
        return errorText.toString();
    }

    private void appendErrorInformation(StringBuffer errorText) {
        this.appendErrorTypeInformation(errorText);
        if (this.getType() != PreverificationErrorType.FINALIZERS) {
            this.appendErrorLocationInformation(errorText);
        }
    }

    private void appendErrorTypeInformation(StringBuffer errorText) {
        switch (this.getType().getErrorCode()) {
            case 3: {
                errorText.append(Messages.PreverificationError_0);
                break;
            }
            case 2: {
                errorText.append(Messages.PreverificationError_1);
                break;
            }
            case 4: {
                errorText.append(Messages.PreverificationError_2);
                break;
            }
            case 1: {
                errorText.append(Messages.PreverificationError_3);
                break;
            }
            case 5: {
                errorText.append(Messages.PreverificationError_4);
            }
        }
    }

    private void appendErrorLocationInformation(StringBuffer errorText) {
        IClassErrorInformation classInfo = this.getLocation().getClassInformation();
        IMethodErrorInformation methodInfo = this.getLocation().getMethodInformation();
        IFieldErrorInformation fieldInfo = this.getLocation().getFieldInformation();
        switch (this.getLocation().getLocationType().getTypeCode()) {
            case 0: {
                errorText.append(Messages.PreverificationError_5).append(classInfo.getName());
                break;
            }
            case 1: {
                errorText.append(Messages.PreverificationError_6).append(fieldInfo.getName());
                break;
            }
            case 2: {
                errorText.append(Messages.PreverificationError_7).append(methodInfo.getName());
                break;
            }
            case 3: {
                errorText.append(Messages.PreverificationError_8).append(methodInfo.getName()).append(Messages.PreverificationError_9).append(classInfo.getName());
                break;
            }
            case 4: {
                errorText.append(Messages.PreverificationError_10).append(methodInfo.getName());
            }
        }
    }
}

