/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.launching;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.model.IExecutablePlatform;
import org.eclipse.mtj.core.Messages;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.exception.MtjException;

public class EmulatorRunner
extends AbstractVMRunner {
    private IExecutablePlatform executablePlatform;
    private DevicePlatform platform;
    private boolean debugMode;

    private static String renderDebugTarget(String classToRun, int host) {
        String ret = MessageFormat.format(Messages.debugvmrunner_debug_target_string, classToRun, String.valueOf(host));
        return ret;
    }

    public static String renderProcessLabel(String[] commandLine) {
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        String ret = MessageFormat.format(Messages.debugvmrunner_process_label_string, commandLine[0], timestamp);
        return ret;
    }

    private static String renderCommandLine(String[] commandLine) {
        StringBuffer buf = new StringBuffer();
        if (commandLine.length > 1) {
            int i = 0;
            while (i < commandLine.length) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(commandLine[i]);
                ++i;
            }
        }
        return buf.toString();
    }

    public EmulatorRunner(DevicePlatform platform, IExecutablePlatform executablePlatform, String mode) throws MtjException {
        this.platform = platform;
        this.executablePlatform = executablePlatform;
        this.debugMode = "debug".equals(mode);
    }

    public void run(VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, Deployment deployment, ILaunch launch, String projectNatureId, Device device, IProgressMonitor monitor) throws CoreException, MtjException {
        if (this.debugMode) {
            this.runInDebug(vmRunnerConfig, launchConfig, deployment, launch, projectNatureId, device, monitor);
        } else {
            this.runWithoutDebug(vmRunnerConfig, launchConfig, deployment, launch, projectNatureId, device, monitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runInDebug(VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, Deployment deployment, ILaunch launch, String projectNatureId, Device device, IProgressMonitor monitor) throws CoreException, MtjException {
        this.platform.setDebugEnabled(true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(Messages.debugvmrunner_launching_vm, 4);
        subMonitor.subTask(Messages.debugvmrunner_finding_free_socket);
        int port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(Messages.debugvmrunner_no_free_socket, null, 118);
        }
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(Messages.debugvmrunner_constructing_cmd_line);
        String[] cmdLine = this.getCommandLine(launchConfig, deployment, port, projectNatureId, device);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(Messages.debugvmrunner_starting_VM);
        Connector connector = this.getConnector();
        if (connector == null) {
            this.abort(Messages.debugvmrunner_no_connector, null, 119);
        }
        Map<String, Connector.Argument> map = connector.defaultArguments();
        this.specifyArguments(map, port);
        Process p = null;
        try {
            try {
                File workingDir;
                if (monitor.isCanceled()) {
                    return;
                }
                if (!this.platform.isDebugEnabled()) {
                    ((ListeningConnector)connector).startListening(map);
                }
                if ((p = this.exec(cmdLine, workingDir = this.getWorkingDir(vmRunnerConfig))) == null) {
                    return;
                }
                if (monitor.isCanceled()) {
                    p.destroy();
                    return;
                }
                IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)EmulatorRunner.renderProcessLabel(cmdLine), (Map)this.getDefaultProcessMap());
                process.setAttribute(IProcess.ATTR_CMDLINE, EmulatorRunner.renderCommandLine(cmdLine));
                subMonitor.worked(1);
                subMonitor.subTask(Messages.debugvmrunner_establishing_debug_conn);
                if (this.platform.isDebugEnabled()) {
                    Preferences preferences = MtjCorePlugin.getDefault().getPluginPreferences();
                    int milliDelay = preferences.getInt("rmt_debug_delay");
                    try {
                        Thread.sleep(milliDelay == 0 ? 5000 : milliDelay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                VirtualMachine vm = this.createVirtualMachine(connector, map, p, process, monitor);
                JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)EmulatorRunner.renderDebugTarget(vmRunnerConfig.getClassToLaunch(), port), (IProcess)process, (boolean)true, (boolean)false);
                subMonitor.worked(1);
                subMonitor.done();
                return;
            }
            finally {
                if (!this.platform.isDebugEnabled()) {
                    ((ListeningConnector)connector).stopListening(map);
                }
            }
        }
        catch (IOException e) {
            this.abort(Messages.debugvmrunner_couldnt_connect_to_vm, e, 120);
        }
        catch (IllegalConnectorArgumentsException e) {
            this.abort(Messages.debugvmrunner_couldnt_connect_to_vm, e, 120);
        }
        if (p == null) return;
        p.destroy();
    }

    private VirtualMachine createVirtualMachine(Connector connector, Map map, Process p, IProcess process, IProgressMonitor monitor) throws IOException, IllegalConnectorArgumentsException, CoreException {
        VirtualMachine vm = this.platform.isDebugEnabled() ? ((AttachingConnector)connector).attach(map) : this.waitForDebuggerConnection((ListeningConnector)connector, p, process, map, monitor);
        return vm;
    }

    private Connector getConnector() {
        Connector connector = this.platform.isDebugEnabled() ? this.getAttachingConnector() : this.getListeningConnector();
        return connector;
    }

    private VirtualMachine waitForDebuggerConnection(ListeningConnector connector, Process p, IProcess process, Map map, IProgressMonitor monitor) throws CoreException, IOException, IllegalConnectorArgumentsException {
        VirtualMachine vm = null;
        boolean retry = false;
        while (true) {
            try {
                ConnectRunnable runnable = new ConnectRunnable(connector, map);
                Thread connectThread = new Thread((Runnable)runnable, "Listening Connector");
                connectThread.start();
                while (connectThread.isAlive()) {
                    if (monitor.isCanceled()) {
                        connector.stopListening(map);
                        p.destroy();
                        break;
                    }
                    try {
                        p.exitValue();
                        try {
                            connector.stopListening(map);
                        }
                        catch (IOException iOException) {}
                        this.checkErrorMessage(process);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Exception ex = runnable.getException();
                if (ex instanceof IllegalConnectorArgumentsException) {
                    throw (IllegalConnectorArgumentsException)ex;
                }
                if (ex instanceof InterruptedIOException) {
                    throw (InterruptedIOException)ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                vm = runnable.getVirtualMachine();
            }
            catch (InterruptedIOException e) {
                this.checkErrorMessage(process);
                Status status = new Status(4, "org.eclipse.mtj.core.ui", 4001, MtjCoreErrors.getErrorMessage(4001), (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                retry = false;
                if (handler == null) {
                    throw new CoreException((IStatus)status);
                }
                Object result = handler.handleStatus((IStatus)status, (Object)this);
                if (!(result instanceof Boolean)) continue;
                retry = (Boolean)result;
                if (retry) continue;
            }
            break;
        }
        return vm;
    }

    public void runWithoutDebug(VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, Deployment deployment, ILaunch launch, String projectNatureId, Device device, IProgressMonitor monitor) throws CoreException, MtjException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(Messages.debugvmrunner_launching_vm, 3);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(Messages.debugvmrunner_constructing_cmd_line);
        String[] cmdLine = this.getCommandLine(launchConfig, deployment, -1, projectNatureId, device);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(Messages.debugvmrunner_starting_VM);
        if (monitor.isCanceled()) {
            return;
        }
        File workingDir = this.getWorkingDir(vmRunnerConfig);
        Process p = this.exec(cmdLine, workingDir);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)EmulatorRunner.renderProcessLabel(cmdLine), (Map)this.getDefaultProcessMap());
        process.setAttribute(IProcess.ATTR_CMDLINE, EmulatorRunner.renderCommandLine(cmdLine));
        subMonitor.worked(1);
    }

    protected String getPluginIdentifier() {
        return "org.eclipse.mtj.core.ui";
    }

    protected void addArguments(String[] args, List allArgs) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                allArgs.add(args[i]);
                ++i;
            }
        }
    }

    protected void checkErrorMessage(IProcess process) throws CoreException {
        String errorMessage = process.getStreamsProxy().getErrorStreamMonitor().getContents();
        if (errorMessage.length() == 0) {
            errorMessage = process.getStreamsProxy().getOutputStreamMonitor().getContents();
        }
        if (errorMessage.length() != 0) {
            this.abort(errorMessage, null, 116);
        }
    }

    private AttachingConnector getAttachingConnector() {
        AttachingConnector connector = null;
        List<AttachingConnector> connectors = Bootstrap.virtualMachineManager().attachingConnectors();
        int i = 0;
        while (i < connectors.size()) {
            AttachingConnector c = connectors.get(i);
            if ("com.sun.jdi.SocketAttach".equals(c.name())) {
                connector = c;
            }
            ++i;
        }
        return connector;
    }

    private ListeningConnector getListeningConnector() {
        ListeningConnector connector = null;
        List<ListeningConnector> connectors = Bootstrap.virtualMachineManager().listeningConnectors();
        int i = 0;
        while (i < connectors.size()) {
            ListeningConnector c = connectors.get(i);
            if ("com.sun.jdi.SocketListen".equals(c.name())) {
                connector = c;
            }
            ++i;
        }
        return connector;
    }

    private File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        File dir = null;
        String path = config.getWorkingDirectory();
        if (path != null && !(dir = new File(path)).isDirectory()) {
            this.abort(MessageFormat.format(Messages.debugvmrunner_workingdir_not_dir, path), null, 108);
        }
        return dir;
    }

    private void specifyArguments(Map map, int portNumber) {
        Connector.IntegerArgument port = (Connector.IntegerArgument)map.get("port");
        port.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)map.get("timeout");
        if (timeoutArg != null) {
            int timeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            timeoutArg.setValue(timeout);
        }
    }

    protected String[] getCommandLine(ILaunchConfiguration config, Deployment deployment, int port, String projectNatureId, Device device) throws MtjException, CoreException {
        ArrayList<String> arguments = new ArrayList<String>(12);
        String commandLineString = this.executablePlatform.getArguments(config, deployment, this.debugMode, port, projectNatureId, device);
        ExecutionArguments execArgs = new ExecutionArguments("", commandLineString);
        File executable = this.executablePlatform.getExecutable();
        if (executable != null) {
            arguments.add(executable.toString());
        }
        arguments.addAll((Collection)Arrays.asList(execArgs.getProgramArgumentsArray()));
        String[] cmdLine = arguments.toArray(new String[arguments.size()]);
        return cmdLine;
    }

    public void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    class ConnectRunnable
    implements Runnable {
        private VirtualMachine fVirtualMachine = null;
        private ListeningConnector fConnector = null;
        private Map fConnectionMap = null;
        private Exception fException = null;

        public ConnectRunnable(ListeningConnector connector, Map map) {
            this.fConnector = connector;
            this.fConnectionMap = map;
        }

        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IOException e) {
                this.fException = e;
            }
            catch (IllegalConnectorArgumentsException e) {
                this.fException = e;
            }
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

