/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.bp.eclipse;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.PackagingProvider;
import org.eclipse.mtj.api.extension.SigningProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.sp.ui.utils.SpUtils;
import org.eclipse.swt.widgets.Shell;

public class BuildProviderUtil {
    static Shell shell = null;

    public static DeploymentType getDeploymentType(IMtjProject mtjProject) throws CoreException {
        DeploymentType dtype = mtjProject.getDeploymentType();
        return dtype;
    }

    public static PackagingProvider getPackagingProvider(IMtjProject mtjProject, DeploymentType dtype) throws MtjException, CoreException {
        PackagingProvider provider = BuildProviderUtil.getPackagingProvider(mtjProject.getProject(), dtype);
        if (provider == null) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)2001));
        }
        return provider;
    }

    public static PackagingProvider getPackagingProvider(IProject project, DeploymentType dtype) throws MtjException, CoreException {
        MtjExtension[] extensions = MtjServices.getInstance().getImplementations(ExtensionType.PACKAGING_PROVIDER_LITERAL, null, null, true);
        int i = 0;
        while (i < extensions.length) {
            PackagingProvider prov = (PackagingProvider)extensions[i];
            DeploymentType[] types = prov.getSupportedTypes();
            int j = 0;
            while (j < types.length) {
                if (types[j].getValue() == dtype.getValue()) {
                    return prov;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static SigningProvider getSigningProvider(IProject project, DeploymentType dtype) throws MtjException {
        SigningProvider[] signingList = (SigningProvider[])SpUtils.getSigningProvidersList();
        int i = 0;
        while (i < signingList.length) {
            if (signingList[i].isActive()) {
                SigningProvider prov = signingList[i];
                DeploymentType[] types = prov.getSupportedTypes();
                int j = 0;
                while (j < types.length) {
                    if (types[j].getValue() == dtype.getValue()) {
                        return prov;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static void displayBuildMessage(MtjException e, String title, String body, int error) {
        if (shell == null) {
            shell = MtjCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (error == 4) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)body, (IStatus)new Status(error, "org.eclipse.mtj.core.ui", -1, e.toString(), (Throwable)e));
        } else {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)body);
        }
    }
}

