/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.bp.eclipse.midp;

import org.apache.tools.ant.BuildException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.extension.SigningProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.SigningDetail;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.signings.SigningCertificate;
import org.eclipse.mtj.api.signings.impl.SigningsFactoryImpl;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.BuildProviderUtil;
import org.eclipse.mtj.extension.bp.eclipse.Messages;
import org.eclipse.mtj.extension.devide.utils.InputValidationDialog;
import org.eclipse.mtj.extension.devide.utils.SmgmtCache;
import org.eclipse.swt.widgets.Shell;

public class MidpSigning {
    static final SmgmtCache keystoreCache = SmgmtCache.getSmgmtCache();
    boolean canSign = false;
    boolean hasGuiUI = true;
    IMtjProject mtjProject;
    IProgressMonitor monitor;
    private IFolder deploymentFolder = null;

    public MidpSigning(IMtjProject mtjProject, IProgressMonitor monitor) {
        this.mtjProject = mtjProject;
        this.monitor = monitor;
    }

    public MidpSigning(IMtjProject mtjProject, IProgressMonitor monitor, boolean callerHasUI) {
        this.hasGuiUI = callerHasUI;
        this.mtjProject = mtjProject;
        this.monitor = monitor;
    }

    public SigningDetail getSigningInfo(IMtjProject mtjProject, IProgressMonitor monitor) {
        SigningDetail sd = null;
        DeploymentType dtype = null;
        TargetDevice targetDevice = null;
        EList signingDetails = null;
        SigningProvider signprov = null;
        try {
            dtype = mtjProject.getDeploymentType();
        }
        catch (CoreException coreException) {
            System.err.println(Messages.BuildProviderImpl_16);
            System.err.println(String.valueOf(Messages.BuildProviderImpl_17) + Messages.BuildProviderImpl_18);
            return null;
        }
        try {
            signprov = BuildProviderUtil.getSigningProvider(mtjProject.getProject(), dtype);
        }
        catch (MtjException mtjException) {}
        if (signprov == null) {
            System.err.println(MtjCoreErrors.getErrorMessage((int)7003));
            return null;
        }
        Project data = null;
        try {
            data = mtjProject.getProjectData();
        }
        catch (MtjException mtjException) {
            System.err.println(Messages.BuildProviderImpl_19);
            System.err.println(String.valueOf(Messages.BuildProviderImpl_20) + Messages.BuildProviderImpl_21);
        }
        if (data != null) {
            targetDevice = data.getDefaultTargetDevice();
            if (targetDevice != null) {
                signingDetails = targetDevice.getSigningDetails();
                if (signingDetails != null) {
                    if (signingDetails.size() > 0) {
                        sd = (SigningDetail)signingDetails.get(0);
                    }
                } else {
                    System.err.println(Messages.BuildProviderImpl_22);
                    System.err.println(String.valueOf(Messages.BuildProviderImpl_23) + Messages.BuildProviderImpl_2);
                }
            } else {
                System.err.println(Messages.BuildProviderImpl_25);
                System.err.println(String.valueOf(Messages.BuildProviderImpl_26) + Messages.BuildProviderImpl_3);
            }
        } else {
            System.err.println(Messages.BuildProviderImpl_28);
            System.err.println(String.valueOf(Messages.BuildProviderImpl_29) + Messages.BuildProviderImpl_4);
        }
        return sd;
    }

    private boolean createSigningCertificate(SigningDetail sd, String password) {
        SigningCertificate sc = new SigningsFactoryImpl().createSigningCertificate();
        sc.setAliasName(sd.getAlias());
        sc.setKeystore(sd.getKeystore());
        sc.setCertificatePassword(password);
        sc.setKeystorePassword(password);
        return keystoreCache.cacheSigningCertificate(sc);
    }

    public boolean preemtSignNoUI(String password) {
        boolean shouldSign = false;
        SigningDetail sd = this.getSigningInfo(this.mtjProject, this.monitor);
        if (sd == null) {
            return false;
        }
        this.canSign = shouldSign = this.createSigningCertificate(sd, password);
        return shouldSign;
    }

    public boolean preemtSign() {
        boolean shouldSign = false;
        SigningDetail sd = this.getSigningInfo(this.mtjProject, this.monitor);
        if (sd != null) {
            if (!keystoreCache.lookupSigningCertificate(sd.getKeystore())) {
                Shell shell = MtjCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                InputValidationDialog promptPassword = new InputValidationDialog(shell, Messages.BuildProviderImpl_1, String.valueOf(Messages.BuildProviderImpl_0) + sd.getKeystore() + Messages.BuildProviderImpl_10 + sd.getAlias(), null, null, (IInputValidator)new oldPasswordLengthValidator(), null, null);
                promptPassword.open();
                if (promptPassword.getReturnCode() == 0) {
                    shouldSign = this.createSigningCertificate(sd, promptPassword.getPass());
                }
            } else {
                shouldSign = true;
            }
        }
        this.canSign = shouldSign;
        return shouldSign;
    }

    public boolean canSign() {
        return this.canSign;
    }

    public void sign(String password) {
        this.hasGuiUI = false;
        boolean canSign = this.preemtSignNoUI(password);
        if (canSign) {
            this.sign();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sign() {
        DeploymentType dtype = null;
        IFolder dfolder = null;
        TargetDevice targetDevice = null;
        EList signingDetails = null;
        Project data = null;
        boolean signed = false;
        try {
            dtype = this.mtjProject.getDeploymentType();
        }
        catch (CoreException coreException) {
            this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.MidpSigning_0), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
        }
        try {
            dfolder = this.getDeploymentFolder();
        }
        catch (CoreException coreException) {
            this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.MidpSigning_3), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
        }
        try {
            data = this.mtjProject.getProjectData();
        }
        catch (MtjException mtjException) {}
        if (data == null) {
            this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_4), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
            return;
        }
        targetDevice = data.getDefaultTargetDevice();
        if (targetDevice == null) {
            this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_3), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
            return;
        }
        signingDetails = targetDevice.getSigningDetails();
        if (signingDetails == null) {
            this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_2), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
            return;
        }
        if (signingDetails.size() <= 0) {
            return;
        }
        SigningProvider signprov = null;
        try {
            signprov = BuildProviderUtil.getSigningProvider(this.mtjProject.getProject(), dtype);
        }
        catch (MtjException mtjException) {}
        if (signprov == null) {
            this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7003)) + Messages.MidpSigning_ConfigureMtjSigningProviders), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
            return;
        }
        try {
            if (signprov.isSigned(this.mtjProject, dfolder, this.monitor) && !signprov.unsign(this.mtjProject, dfolder, this.monitor)) {
                this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_6), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
                return;
            }
        }
        catch (MtjException mtjException) {
            this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.MidpSigning_6), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
            return;
        }
        SigningDetail sd = (SigningDetail)signingDetails.get(0);
        SigningCertificate sc = SigningsFactoryImpl.eINSTANCE.createSigningCertificate();
        if (!keystoreCache.lookupSigningCertificate(sd.getKeystore())) return;
        sc = keystoreCache.getSigningCertificate(sd.getKeystore());
        sc.setAliasName(sd.getAlias());
        try {
            try {
                signed = signprov.sign(this.mtjProject, this.getDeploymentFolder(), sc, this.monitor);
            }
            catch (MtjException e) {
                this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_9 + e.getMessage(), (Throwable)e), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
            }
            catch (CoreException e) {
                this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_9 + e.getMessage(), (Throwable)e), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
            }
        }
        catch (Throwable throwable) {
            if (signed) throw throwable;
            this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_9), Messages.BuildProviderImpl_14, String.valueOf(Messages.BuildProviderImpl_15) + Messages.MidpSigning_17, 4);
            signingDetails.clear();
            try {
                this.mtjProject.setProjectData(data);
                keystoreCache.unCacheSigningCertificate(sc);
                throw throwable;
            }
            catch (MtjException mtjException) {}
            throw throwable;
        }
        if (signed) return;
        this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_9), Messages.BuildProviderImpl_14, String.valueOf(Messages.BuildProviderImpl_15) + Messages.MidpSigning_17, 4);
        signingDetails.clear();
        try {
            this.mtjProject.setProjectData(data);
            keystoreCache.unCacheSigningCertificate(sc);
            return;
        }
        catch (MtjException mtjException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unsign() {
        DeploymentType dtype = null;
        IFolder dfolder = null;
        SigningProvider signprov = null;
        EList signingDetails = null;
        Project data = null;
        TargetDevice targetDevice = null;
        try {
            dfolder = this.mtjProject.getDeploymentFolder(null);
            dtype = this.mtjProject.getDeploymentType();
            try {
                signprov = BuildProviderUtil.getSigningProvider(this.mtjProject.getProject(), dtype);
            }
            catch (MtjException mtjException) {
                this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7003)) + Messages.MidpSigning_7), Messages.BuildProviderImpl_30, Messages.BuildProviderImpl_30, 4);
                return false;
            }
            if (signprov == null) {
                this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7003)) + Messages.MidpSigning_10), Messages.BuildProviderImpl_30, Messages.BuildProviderImpl_30, 4);
                return false;
            }
            if (!signprov.isSigned(this.mtjProject, dfolder, this.monitor)) {
                this.displaySigningStepMessage(new MtjException(MtjCoreErrors.getErrorMessage((int)7000)), Messages.BuildProviderImpl_30, Messages.MidpSigning_14, 1);
                return false;
            }
            if (!signprov.unsign(this.mtjProject, dfolder, this.monitor)) {
                this.displaySigningStepMessage(new MtjException(MtjCoreErrors.getErrorMessage((int)7000)), Messages.BuildProviderImpl_30, Messages.BuildProviderImpl_15, 4);
                return false;
            }
            data = this.mtjProject.getProjectData();
            if (data == null) {
                this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_4), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
                return false;
            }
            targetDevice = data.getDefaultTargetDevice();
            if (targetDevice == null) {
                this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_3), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
                return false;
            }
            signingDetails = targetDevice.getSigningDetails();
            if (signingDetails == null) {
                this.displaySigningStepMessage(new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.BuildProviderImpl_2), Messages.BuildProviderImpl_14, Messages.BuildProviderImpl_15, 4);
                return false;
            }
            if (signingDetails.size() <= 0) {
                this.displaySigningStepMessage(new MtjException(MtjCoreErrors.getErrorMessage((int)7000)), Messages.BuildProviderImpl_30, Messages.MidpSigning_16, 1);
                return true;
            }
            EList i = targetDevice.getSigningDetails();
            if (i != null) {
                i.clear();
            }
            this.mtjProject.setProjectData(data);
            return true;
        }
        catch (CoreException coreException) {
            this.displaySigningStepMessage(new MtjException(MtjCoreErrors.getErrorMessage((int)7000)), Messages.BuildProviderImpl_30, Messages.BuildProviderImpl_30, 4);
            return false;
        }
        catch (MtjException mtjException) {
            this.displaySigningStepMessage(new MtjException(MtjCoreErrors.getErrorMessage((int)7000)), Messages.BuildProviderImpl_30, Messages.BuildProviderImpl_30, 4);
            return false;
        }
    }

    public void displaySigningStepMessage(MtjException e, String title, String body, int error) {
        if (!this.hasGuiUI) {
            throw new BuildException((Throwable)e);
        }
        BuildProviderUtil.displayBuildMessage(e, title, body, error);
    }

    public IFolder getDeploymentFolder() throws CoreException {
        if (this.deploymentFolder == null) {
            this.deploymentFolder = this.mtjProject.getDeploymentFolder(this.monitor);
        }
        return this.deploymentFolder;
    }

    public void setDeploymentFolder(IFolder deploymentFolder) {
        this.deploymentFolder = deploymentFolder;
    }

    public class oldPasswordLengthValidator
    implements IInputValidator {
        public String isValid(String arg0) {
            if (this.checkBlankChars(arg0)) {
                return Messages.BuildProviderImpl_11;
            }
            if (arg0.length() < 1) {
                return Messages.BuildProviderImpl_12;
            }
            return null;
        }

        public boolean checkBlankChars(String text) {
            return text.indexOf(" ") != -1;
        }
    }
}

