/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.pp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.PackagingProvider;
import org.eclipse.mtj.api.extension.impl.BuildExtensionImpl;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.packaging.MidpPackagingResources;
import org.eclipse.mtj.api.project.Parameter;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.version.Version;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.devide.utils.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.extension.devide.utils.IClasspathEntryVisitor;
import org.eclipse.mtj.extension.pp.Messages;
import org.eclipse.mtj.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.internal.utils.EntryTrackingJarOutputStream;
import org.eclipse.mtj.internal.utils.Utils;
import org.eclipse.mtj.jad.util.SynchronizeManifestFileToJad;

public class MidpPackagingProviderImpl
extends BuildExtensionImpl
implements PackagingProvider {
    public static final String EXT_JAR_NAME = "packager.jar";
    public static final String RESOURCE_DIRECTORY_NAME = "res";
    Properties midletProperties;

    public MidpPackagingProviderImpl() {
        this.setId("org.eclipse.mtj.extension.pp.MIDLET");
        this.setDescription(Messages.MidpPackagingProviderImpl_PluginDescription);
        this.setVendor(Messages.MidpPackagingProviderImpl_PluginVendor);
        this.setVersion(Messages.MidpPackagingProviderImpl_PluginVersion);
        this.setType(ExtensionType.PACKAGING_PROVIDER_LITERAL);
        this.setExtJar(EXT_JAR_NAME);
    }

    public DeploymentType[] getSupportedTypes() throws MtjException {
        DeploymentType[] ret = new DeploymentType[]{DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL};
        return ret;
    }

    public void setMidletProperties(Properties midletProperties) {
        this.midletProperties = midletProperties;
    }

    private void deploy(String projectName, Project projectData, IResource[] resources, IFolder deploymentFolder, DeploymentType type, String natureId, IProgressMonitor monitor) throws CoreException, IOException {
        boolean autoVersion;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        IMtjProject mtjProject = null;
        try {
            mtjProject = MtjProject.getMtjProject((IProject)project);
        }
        catch (MtjException mtjException) {}
        IFolder projectFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(project.getLocation());
        IFile finalJarFile = this.getJarFile(projectName, deploymentFolder, "");
        if (finalJarFile.exists()) {
            finalJarFile.delete(true, monitor);
        }
        boolean bl = autoVersion = projectData.getPackagingDetails() != null ? projectData.getPackagingDetails().isIncrementVersionAutomatically() : false;
        if (autoVersion) {
            this.updateJADVersion(projectName, projectFolder, monitor);
        }
        MidpPackagingResources midpPackagingResources = new MidpPackagingResources(resources);
        IFolder verifiedClassesOutputFolder = midpPackagingResources.getVerifiedClassesOutputFolder();
        IFolder verifiedLibrariesOutputFolder = midpPackagingResources.getVerifiedLibrariesOutputFolder();
        IFolder resourcesFolder = null;
        if (mtjProject != null) {
            resourcesFolder = mtjProject.getFolder(RESOURCE_DIRECTORY_NAME, monitor);
        }
        File deployedJar = this.createDeployedJarFile(projectName, projectData, verifiedLibrariesOutputFolder, verifiedClassesOutputFolder, resourcesFolder, monitor, deploymentFolder, projectFolder, natureId);
        this.copyAndUpdateJadFile(projectName, deploymentFolder, deployedJar);
        deploymentFolder.refreshLocal(1, monitor);
    }

    public Deployment createDeployment(String projectName, Project projectData, IResource[] resources, IFolder deploymentFolder, DeploymentType type, String natureId, IProgressMonitor monitor) throws MtjException {
        try {
            this.deploy(projectName, projectData, resources, deploymentFolder, type, natureId, monitor);
            return null;
        }
        catch (CoreException coreException) {
            throw new MtjException();
        }
        catch (IOException iOException) {
            throw new MtjException();
        }
    }

    private void updateJADVersion(String projectName, IFolder folder, IProgressMonitor monitor) throws IOException, CoreException {
        ColonDelimitedProperties jadProperties = this.getSourceJADProperties(projectName);
        String versionString = jadProperties.getProperty("MIDlet-Version", "0.0.0");
        Version version = new Version(versionString);
        StringBuffer newVersion = new StringBuffer();
        String major = version.getMajor();
        newVersion.append(major != null ? major : "0").append(".");
        String minor = version.getMinor();
        newVersion.append(minor != null ? minor : "0").append(".");
        int secondaryInt = 0;
        String secondary = version.getSecondary();
        if (secondary == null) {
            secondary = "0";
        }
        try {
            secondaryInt = Integer.parseInt(secondary);
        }
        catch (NumberFormatException numberFormatException) {}
        newVersion.append(++secondaryInt);
        jadProperties.setProperty("MIDlet-Version", newVersion.toString());
        IFile jadSourceFile = this.getJadFile(projectName);
        this.writeJad(projectName, folder, jadProperties);
        jadSourceFile.refreshLocal(1, monitor);
    }

    private IFile getJarFile(String projectName, IFolder deploymentFolder, String extension) {
        String jarFileName = String.valueOf(projectName.replace(' ', '_')) + extension + ".jar";
        return deploymentFolder.getFile(jarFileName);
    }

    private File createDeployedJarFile(String projectName, Project projectData, IFolder verifiedLibrariesOutputFolder, IFolder verifiedClassesOutputFolder, IFolder resourcesFolder, IProgressMonitor monitor, IFolder deploymentFolder, IFolder projectFolder, String natureId) throws CoreException, IOException {
        IFile jarIFile = this.getJarFile(projectName, deploymentFolder, "");
        IFile jadIFile = this.getJadFile(projectName);
        SynchronizeManifestFileToJad info = new SynchronizeManifestFileToJad(jadIFile);
        try {
            info.run(monitor);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        IFile manifestIFile = info.getManifestFile();
        Manifest jarManifest = new Manifest(manifestIFile.getContents());
        File jarFile = this.resourceToFile((IResource)jarIFile);
        FileOutputStream fos = new FileOutputStream(jarFile);
        EntryTrackingJarOutputStream jarOutputStream = new EntryTrackingJarOutputStream((OutputStream)fos, jarManifest);
        this.addVerifiedClasspathContentsToJar(jarOutputStream, projectName, verifiedLibrariesOutputFolder, verifiedClassesOutputFolder, natureId, monitor);
        if (resourcesFolder != null) {
            this.addFilteredResourcesToJar(jarOutputStream, new IncludeAllResourceFilter(), resourcesFolder.getFullPath(), (IContainer)resourcesFolder);
        }
        jarOutputStream.close();
        return this.resourceToFile((IResource)this.getJarFile(projectName, deploymentFolder, ""));
    }

    private void addVerifiedClasspathContentsToJar(EntryTrackingJarOutputStream jarOutputStream, String projectName, IFolder verifiedLibrariesOutputFolder, IFolder verifiedClassesOutputFolder, String natureId, IProgressMonitor monitor) throws CoreException, IOException {
        IJavaProject javaProject = this.getJavaProject(projectName);
        PackagerClasspathEntryVisitor visitor = new PackagerClasspathEntryVisitor(jarOutputStream, verifiedLibrariesOutputFolder, verifiedClassesOutputFolder);
        visitor.getRunner().run(javaProject, (IClasspathEntryVisitor)visitor, natureId, monitor);
    }

    private IJavaProject getJavaProject(String projectName) {
        return JavaCore.create((IProject)this.getProject(projectName));
    }

    private IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private void filterManifestAttributes(Project projectData, Properties attributes) {
        ArrayList<String> excluded = new ArrayList<String>();
        if (projectData.getPackagingDetails() != null && projectData.getPackagingDetails().getExculedManifestEntries() != null) {
            Iterator it = projectData.getPackagingDetails().getExculedManifestEntries().iterator();
            while (it.hasNext()) {
                excluded.add(((Parameter)it.next()).getName());
            }
            int i = 0;
            while (i < excluded.size()) {
                String excludedName = (String)excluded.get(i);
                if (attributes.containsKey(excludedName)) {
                    attributes.remove(excludedName);
                }
                ++i;
            }
        }
    }

    private ColonDelimitedProperties getJadSourceManifest(String projectName, IFolder deploymentFolder) throws IOException, CoreException {
        ColonDelimitedProperties properties = new ColonDelimitedProperties();
        properties.load(this.getJadSourceStream(projectName, deploymentFolder));
        return properties;
    }

    private InputStream getJadSourceStream(String projectName, IFolder folder) throws IOException, CoreException {
        return this.getJadFile(projectName, folder).getContents(true);
    }

    private IFile getJadFile(String projectName) {
        return this.getJadFile(projectName, null);
    }

    private IFile getJadFile(String projectName, IFolder deploymentFolder) {
        if (deploymentFolder == null) {
            IProject iproject = this.getProject(projectName);
            return iproject.getFile(this.getJadSourceFile(projectName));
        }
        return deploymentFolder.getFile(this.getJadSourceFile(projectName));
    }

    private String getJadSourceFile(String projectName) {
        return String.valueOf(projectName.replace(' ', '_')) + ".jad";
    }

    private File resourceToFile(IResource resource) {
        return new File(resource.getLocation().toOSString());
    }

    private void copyAndUpdateJadFile(String projectName, IFolder deploymentFolder, File deployedJarFile) throws IOException, CoreException {
        ColonDelimitedProperties jadProperties = this.getSourceJADProperties(projectName);
        jadProperties.setProperty("MIDlet-Jar-Size", new Long(deployedJarFile.length()).toString());
        int count = 1;
        if (this.midletProperties != null) {
            Enumeration<Object> e = this.midletProperties.elements();
            while (e.hasMoreElements()) {
                String m = (String)e.nextElement();
                jadProperties.setProperty("MIDlet-" + count, m);
                ++count;
            }
        }
        this.writeJad(projectName, deploymentFolder, jadProperties);
    }

    private void writeJad(String projectName, IFolder outputFolder, ColonDelimitedProperties jadProperties) throws IOException {
        IFile jadFile = this.getJadFile(projectName, outputFolder);
        File outputFile = this.resourceToFile((IResource)jadFile);
        FileOutputStream stream = new FileOutputStream(outputFile);
        jadProperties.store((OutputStream)stream, "");
        stream.close();
    }

    private ColonDelimitedProperties getSourceJADProperties(String projectName) throws IOException, CoreException {
        ColonDelimitedProperties jadProperties = new ColonDelimitedProperties();
        InputStream jadStream = this.getJadSourceStream(projectName, null);
        jadProperties.load(jadStream);
        jadStream.close();
        return jadProperties;
    }

    private void addFilteredResourcesToJar(EntryTrackingJarOutputStream jarOutputStream, IResourceFilter resourceFilter, IPath rootPath, IContainer container) throws CoreException, IOException {
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (resource instanceof IContainer) {
                IContainer cont = (IContainer)resource;
                if (resourceFilter.shouldTraverseContainer(cont)) {
                    this.addFilteredResourcesToJar(jarOutputStream, resourceFilter, rootPath, cont);
                }
            } else if (resource.getType() == 1 && resourceFilter.shouldBeIncluded((IFile)resource)) {
                this.addResourceToJar(jarOutputStream, rootPath, resource);
            }
            ++i;
        }
    }

    private void addResourceToJar(EntryTrackingJarOutputStream jarOutputStream, IPath rootPath, IResource resource) throws IOException {
        IPath resourcePath = resource.getFullPath();
        int commonSegments = resourcePath.matchingFirstSegments(rootPath);
        IPath entryPath = resourcePath.removeFirstSegments(commonSegments);
        File file = new File(resource.getLocation().toOSString());
        this.addFileToJar(jarOutputStream, entryPath.toString(), file);
    }

    private void addFileToJar(EntryTrackingJarOutputStream jarOutputStream, String entryName, File file) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setSize(file.length());
        entry.setTime(file.lastModified());
        this.createJarEntry(jarOutputStream, entry, new FileInputStream(file));
    }

    private void createJarEntry(EntryTrackingJarOutputStream jarOutputStream, ZipEntry zipEntry, InputStream is) throws IOException {
        ZipEntry newEntry = new ZipEntry(zipEntry.getName());
        newEntry.setTime(zipEntry.getTime());
        if (zipEntry.getComment() != null) {
            newEntry.setComment(zipEntry.getComment());
        }
        if (zipEntry.getExtra() != null) {
            newEntry.setExtra(zipEntry.getExtra());
        }
        if (!jarOutputStream.alreadyAdded(zipEntry)) {
            jarOutputStream.putNextEntry(newEntry);
            Utils.copyInputToOutput((InputStream)is, (OutputStream)jarOutputStream);
            jarOutputStream.closeEntry();
        }
    }

    private class PackagerClasspathEntryVisitor
    extends FilteringClasspathEntryVisitor {
        private EntryTrackingJarOutputStream jarStream;
        private boolean visitedSource;
        private IFolder verifiedLibrariesOutputFolder;
        private IFolder verifiedClassesOutputFolder;

        private PackagerClasspathEntryVisitor(EntryTrackingJarOutputStream jarStream, IFolder verifiedLibrariesOutputFolder, IFolder verifiedClassesOutputFolder) {
            this.jarStream = jarStream;
            this.verifiedLibrariesOutputFolder = verifiedLibrariesOutputFolder;
            this.verifiedClassesOutputFolder = verifiedClassesOutputFolder;
            this.visitedSource = false;
        }

        public void visitLibraryEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
            IFile lib;
            File entryFile = Utils.getResolvedClasspathEntryFile((IClasspathEntry)entry);
            if (entryFile != null && entryFile.isFile() && (lib = this.verifiedLibrariesOutputFolder.getFile(entry.getPath().lastSegment())).exists()) {
                try {
                    this.copyLibContentsToJar(this.jarStream, lib, monitor);
                }
                catch (IOException e) {
                    MtjCorePlugin.throwCoreException((int)4, (int)-999, (Throwable)e);
                }
            }
        }

        public void visitSourceEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
            if (!this.visitedSource) {
                this.visitedSource = true;
                try {
                    MidpPackagingProviderImpl.this.addFilteredResourcesToJar(this.jarStream, new IncludeAllResourceFilter(), this.verifiedClassesOutputFolder.getFullPath(), (IContainer)this.verifiedClassesOutputFolder);
                }
                catch (IOException e) {
                    MtjCorePlugin.throwCoreException((int)4, (int)-999, (Throwable)e);
                }
            }
        }

        private void copyLibContentsToJar(EntryTrackingJarOutputStream jarOutputStream, IFile lib, IProgressMonitor monitor) throws IOException {
            File libFile = lib.getLocation().toFile();
            ZipInputStream zis = new ZipInputStream(new FileInputStream(libFile));
            ZipEntry zipEntry = null;
            do {
                if ((zipEntry = zis.getNextEntry()) == null) continue;
                MidpPackagingProviderImpl.this.createJarEntry(jarOutputStream, zipEntry, zis);
            } while (zipEntry != null);
            zis.close();
        }
    }

    private class IncludeAllResourceFilter
    implements IResourceFilter {
        private IncludeAllResourceFilter() {
        }

        public boolean shouldTraverseContainer(IContainer container) {
            return true;
        }

        public boolean shouldBeIncluded(IFile file) {
            return true;
        }
    }

    public static interface IResourceFilter {
        public boolean shouldTraverseContainer(IContainer var1);

        public boolean shouldBeIncluded(IFile var1);
    }
}

