/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.ui.preferences;

import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.extension.dm.ui.Messages;

public class DevicePlatformListContentProvider
implements ITreeContentProvider {
    private EList myContents;
    private Viewer myViewer;

    public DevicePlatformListContentProvider(Viewer viewer) {
        this.myViewer = viewer;
    }

    public Object[] getChildren(Object parentElement) {
        Vector<Object> l = new Vector<Object>();
        if (parentElement instanceof DevicePlatform) {
            DevicePlatform dp = (DevicePlatform)parentElement;
            l.addAll((Collection<Object>)dp.getDevices());
            l.addAll((Collection<Object>)dp.getRuntimePlatformDefinitions());
            return l.toArray();
        }
        if (parentElement instanceof RuntimePlatformDefinition) {
            RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)parentElement;
            l.addAll((Collection<Object>)rpd.getDeviceConfigurations());
            l.addAll((Collection<Object>)rpd.getDeviceProfiles());
            l.addAll((Collection<Object>)rpd.getServiceApis());
            return l.toArray();
        }
        if (parentElement instanceof Device) {
            Device device = (Device)parentElement;
            EList rpds = device.getRuntimePlatformDefinitions();
            if (rpds != null) {
                l.addAll((Collection<Object>)device.getRuntimePlatformDefinitions());
                return l.toArray();
            }
            return null;
        }
        if (parentElement instanceof DeviceConfiguration) {
            DeviceConfiguration config = (DeviceConfiguration)parentElement;
            l.add(config.getImplementation());
            return l.toArray();
        }
        if (parentElement instanceof DeviceProfile) {
            DeviceProfile profile = (DeviceProfile)parentElement;
            l.addAll((Collection<Object>)profile.getServiceApis());
            return l.toArray();
        }
        if (parentElement instanceof ServiceApi) {
            ServiceApi sapi = (ServiceApi)parentElement;
            l.add(sapi.getDescription());
            l.add(sapi.getImplementation());
            return l.toArray();
        }
        if (parentElement instanceof ImplementationRef) {
            ImplementationRef ref = (ImplementationRef)parentElement;
            l.add(ref.getSourceRef());
            l.add(ref.getJavadocRef());
            return l.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        boolean cfr_ignored_0 = element instanceof Device;
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof DevicePlatform) {
            return true;
        }
        if (element instanceof RuntimePlatformDefinition) {
            return true;
        }
        if (element instanceof Device) {
            return true;
        }
        if (element instanceof DeviceProfile) {
            return true;
        }
        if (element instanceof DeviceConfiguration) {
            return true;
        }
        if (element instanceof ServiceApi) {
            return true;
        }
        if (element instanceof ImplementationRef) {
            ImplementationRef ref = (ImplementationRef)element;
            String javadoc = ref.getJavadocRef();
            String source = ref.getSourceRef();
            if (javadoc != null && source != null) {
                return javadoc.length() > 1 || source.length() > 1;
            }
            return false;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof EList) {
            EList eList = (EList)inputElement;
            return eList.toArray();
        }
        return ((Set)inputElement).toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
        if (newInput instanceof EList) {
            this.myContents = (EList)newInput;
        }
    }

    public void addVariable(Object inputElement, RuntimePlatformDefinition newRpd) {
        EList eList = null;
        if (inputElement == null) {
            inputElement = new EObjectContainmentEList(RuntimePlatformDefinition.class, (InternalEObject)newRpd, 3);
            ((EList)inputElement).add((Object)newRpd);
        } else if (inputElement instanceof EList && ((eList = (EList)inputElement).size() == 0 || eList.get(0) instanceof RuntimePlatformDefinition)) {
            ((EList)inputElement).add((Object)newRpd);
        }
        this.myViewer.setInput(inputElement);
    }

    public EList removeVariable(Object oldInputElement, DevicePlatform selectedDp) throws Exception {
        if (oldInputElement instanceof DevicePlatform) {
            DevicePlatform[] oldInput = (DevicePlatform[])oldInputElement;
            if (oldInput.length == 1) {
                return null;
            }
            BasicEList list = new BasicEList();
            int i = 0;
            while (i < oldInput.length) {
                if (!oldInput[i].equals(selectedDp)) {
                    list.add((Object)oldInput[i]);
                }
                ++i;
            }
            return list;
        }
        if (oldInputElement instanceof EList) {
            EList list = (EList)oldInputElement;
            if (list.size() == 1) {
                return null;
            }
            list.remove((Object)selectedDp);
            return list;
        }
        throw new Exception(Messages.DevicePlatformListContentProvider_UnknownContentType);
    }
}

