/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.ui.util;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;

public class ClassLibraryContentProvider
implements ITreeContentProvider {
    private TreeViewer myViewer;
    private Object myInput;

    public ClassLibraryContentProvider(TreeViewer treeViewer) {
        this.myViewer = treeViewer;
    }

    public Object[] getChildren(Object parentElement) {
        Vector<Object> l = new Vector<Object>();
        if (parentElement instanceof EList) {
            EList list = (EList)parentElement;
            return list.toArray();
        }
        if (parentElement instanceof RuntimePlatformDefinition) {
            RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)parentElement;
            l.addAll((Collection<Object>)rpd.getDeviceConfigurations());
            l.addAll((Collection<Object>)rpd.getDeviceProfiles());
            l.addAll((Collection<Object>)rpd.getServiceApis());
        } else if (parentElement instanceof DeviceConfiguration) {
            DeviceConfiguration config = (DeviceConfiguration)parentElement;
            l.add(config.getImplementation());
        } else if (parentElement instanceof DeviceProfile) {
            DeviceProfile profile = (DeviceProfile)parentElement;
            l.addAll((Collection<Object>)profile.getServiceApis());
        } else if (parentElement instanceof ServiceApi) {
            ServiceApi sapi = (ServiceApi)parentElement;
            l.add(sapi.getDescription());
            l.add(sapi.getImplementation());
        } else if (parentElement instanceof ImplementationRef) {
            ImplementationRef ref = (ImplementationRef)parentElement;
            l.add(ref.getSourceRef());
            l.add(ref.getJavadocRef());
        }
        return l.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof EList) {
            return true;
        }
        if (parentElement instanceof RuntimePlatformDefinition) {
            return true;
        }
        if (parentElement instanceof DeviceConfiguration) {
            return true;
        }
        if (parentElement instanceof DeviceProfile) {
            return true;
        }
        if (parentElement instanceof ServiceApi) {
            return true;
        }
        if (parentElement instanceof ImplementationRef) {
            ImplementationRef ref = (ImplementationRef)parentElement;
            String javadoc = ref.getJavadocRef();
            String source = ref.getSourceRef();
            if (javadoc != null && source != null) {
                return javadoc.length() > 1 || source.length() > 1;
            }
            return false;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = null;
        if (inputElement instanceof EList) {
            EList eList = (EList)inputElement;
            return eList.toArray();
        }
        if (inputElement instanceof RuntimePlatformDefinition) {
            RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)inputElement;
            elements = new Object[]{rpd.getDeviceProfiles().get(0), rpd.getDeviceConfigurations().get(0), (ServiceApi[])rpd.getServiceApis().toArray()};
        } else if (inputElement instanceof DeviceConfiguration) {
            DeviceConfiguration config = (DeviceConfiguration)inputElement;
            elements = new Object[]{config.getImplementation()};
        } else if (inputElement instanceof DeviceProfile) {
            DeviceProfile profile = (DeviceProfile)inputElement;
            elements = new Object[]{(ServiceApi[])profile.getServiceApis().toArray()};
        } else if (inputElement instanceof ServiceApi) {
            ServiceApi sapi = (ServiceApi)inputElement;
            elements = new Object[]{sapi.getDescription(), sapi.getImplementation()};
        } else {
            if (inputElement instanceof ServiceApi[]) {
                return (ServiceApi[])inputElement;
            }
            if (inputElement instanceof ImplementationRef) {
                ImplementationRef ref = (ImplementationRef)inputElement;
                elements = new Object[]{ref.getFileRef(), ref.getSourceRef(), ref.getJavadocRef()};
            } else {
                elements = new Object[]{inputElement};
            }
        }
        return elements;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = (TreeViewer)viewer;
        this.myInput = newInput;
    }
}

