/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.impl;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DeviceDescription;
import org.eclipse.mtj.api.devices.DeviceGroup;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.extension.DeviceDescriptionProvider;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dm.Messages;
import org.eclipse.mtj.extension.dm.MtjDeviceManagementPlugin;

public class DeviceManagementImpl
extends MtjExtensionImpl
implements DeviceManagement {
    public DeviceManagementImpl() {
        this.setId(MtjDeviceManagementPlugin.getDefault().getBundle().getSymbolicName());
        this.setDescription(Messages.DeviceManagementImpl_Description);
        this.setVendor(Messages.DeviceManagementImpl_Vendor);
        this.setVersion(Messages.DeviceManagementImpl_Version);
        this.setType(ExtensionType.DEVICE_MANAGEMENT_LITERAL);
    }

    public void removeDevicePlatform(DevicePlatform devicePlatform) throws MtjException {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        boolean done = false;
        int i = 0;
        while (i < list.length) {
            DevicePlatformProvider provider = (DevicePlatformProvider)list[i];
            try {
                DevicePlatform[] devicePlatforms = provider.getDevicePlatforms();
                int j = 0;
                while (j < devicePlatforms.length) {
                    if (devicePlatforms[j].getDevicePlatformProvider().getId().equals(devicePlatform.getDevicePlatformProvider().getId())) {
                        DevicePlatformProvider dpp = (DevicePlatformProvider)devicePlatforms[j].getDevicePlatformProvider();
                        if (dpp instanceof ToolkitSupport) {
                            DevicePlatform[] dps = dpp.getDevicePlatforms();
                            if (dps.length > 0) {
                                DevicePlatform[] newDps = new DevicePlatform[dps.length - 1];
                                int ix = 0;
                                boolean found = false;
                                int c = 0;
                                while (c < dps.length) {
                                    if (dps[c].getName().equals(devicePlatform.getName())) {
                                        found = true;
                                    } else {
                                        newDps[ix] = dps[c];
                                        ++ix;
                                    }
                                    ++c;
                                }
                                if (found) {
                                    ((ToolkitSupport)dpp).setDevicePlatforms(newDps);
                                    done = true;
                                    break;
                                }
                            }
                        } else {
                            throw new MtjException(Messages.DeviceManagementImpl_3);
                        }
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                throw new MtjException(Messages.DeviceManagementImpl_4, (Throwable)e);
            }
            ++i;
        }
        if (!done) {
            throw new MtjException(Messages.DeviceManagementImpl_5);
        }
    }

    public DevicePlatform[] getDevicePlatforms() throws MtjException {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        ArrayList<DevicePlatform> l = new ArrayList<DevicePlatform>();
        int i = 0;
        while (i < list.length) {
            DevicePlatformProvider provider = (DevicePlatformProvider)list[i];
            try {
                DevicePlatform[] devicePlatforms = provider.getDevicePlatforms();
                int j = 0;
                while (j < devicePlatforms.length) {
                    l.add(devicePlatforms[j]);
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        DevicePlatform[] resp = new DevicePlatform[l.size()];
        int i2 = 0;
        while (i2 < l.size()) {
            resp[i2] = (DevicePlatform)l.get(i2);
            ++i2;
        }
        return resp;
    }

    public Device[] getDevices(String devicePlatformName) throws MtjException {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        int i = 0;
        while (i < list.length) {
            DevicePlatform[] devicePlatforms = ((DevicePlatformProvider)list[i]).getDevicePlatforms();
            int c = 0;
            while (c < devicePlatforms.length) {
                DevicePlatform dp = devicePlatforms[c];
                if (dp != null && dp.getName() != null && dp.getName().equals(devicePlatformName)) {
                    EList l = dp.getDevices();
                    Device[] resp = new Device[l.size()];
                    int j = 0;
                    while (j < l.size()) {
                        resp[j] = (Device)l.get(j);
                        ++j;
                    }
                    return resp;
                }
                ++c;
            }
            ++i;
        }
        return null;
    }

    public Device getDevice(String devicePlatformName, String deviceName) throws MtjException {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        int i = 0;
        while (i < list.length) {
            DevicePlatform[] devicePlatforms = ((DevicePlatformProvider)list[i]).getDevicePlatforms();
            int c = 0;
            while (c < devicePlatforms.length) {
                DevicePlatform dp = devicePlatforms[c];
                if (dp != null && dp.getName() != null && dp.getName().equals(devicePlatformName)) {
                    EList l = dp.getDevices();
                    int j = 0;
                    while (j < l.size()) {
                        Device device = (Device)l.get(j);
                        if (device.getName() != null && device.getName().equals(deviceName)) {
                            return device;
                        }
                        ++j;
                    }
                }
                ++c;
            }
            ++i;
        }
        return null;
    }

    public DeviceDescription getDeviceDescription(String vendor, String model) throws MtjException {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        int i = 0;
        while (i < list.length) {
            DeviceDescription dd = ((DeviceDescriptionProvider)list[i]).getDeviceDescription(vendor, model);
            if (dd != null) {
                return dd;
            }
            ++i;
        }
        return null;
    }

    public DeviceDescription[] getMatchingDeviceDescriptions(DeviceGroup group) throws MtjException {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        ArrayList<DeviceDescription> l = new ArrayList<DeviceDescription>();
        int i = 0;
        while (i < list.length) {
            DeviceDescription[] dd = ((DeviceDescriptionProvider)list[i]).getMatchingDeviceDescriptions(group);
            if (dd != null) {
                int j = 0;
                while (j < dd.length) {
                    l.add(dd[j]);
                    ++j;
                }
            }
            ++i;
        }
        DeviceDescription[] resp = new DeviceDescription[l.size()];
        int i2 = 0;
        while (i2 < l.size()) {
            resp[i2] = (DeviceDescription)l.get(i2);
            ++i2;
        }
        return resp;
    }

    public DeviceGroup[] getDeviceGroups() throws MtjException {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        ArrayList<DeviceGroup> l = new ArrayList<DeviceGroup>();
        int i = 0;
        while (i < list.length) {
            DeviceGroup[] dg = ((DeviceDescriptionProvider)list[i]).getDeviceGroups();
            if (dg != null) {
                int j = 0;
                while (j < dg.length) {
                    l.add(dg[j]);
                    ++j;
                }
            }
            ++i;
        }
        DeviceGroup[] resp = new DeviceGroup[l.size()];
        int i2 = 0;
        while (i2 < l.size()) {
            resp[i2] = (DeviceGroup)l.get(i2);
            ++i2;
        }
        return resp;
    }

    public DeviceDescription[] getDevices(DeviceConfiguration deviceConfig, DeviceProfile deviceProfile, ServiceApi[] apis) throws MtjException {
        return null;
    }

    public Device[] getTargetDevices(DeviceConfiguration deviceConfig, DeviceProfile deviceProfile, ServiceApi[] apis, PlatformType devicePlatformType) throws MtjException {
        return null;
    }

    public RuntimePlatformDefinition[] getRuntimePlatforms(String devicePlatformName, String deviceName) throws MtjException {
        return null;
    }

    public Device[] getDeployableDevices(DeviceConfiguration deviceConfig, DeviceProfile deviceProfile, ServiceApi[] apis, PlatformType devicePlatformType) throws MtjException {
        return null;
    }

    public DevicePlatform getDevicePlatformByName(String name) throws MtjException {
        DevicePlatform[] dps = this.getDevicePlatforms();
        int i = 0;
        while (i < dps.length) {
            if (name.equals(dps[i].getName())) {
                return dps[i];
            }
            ++i;
        }
        return null;
    }

    public DevicePlatformProvider getDevicePlatformProvider(DevicePlatform devicePlatform) throws MtjException {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        new ArrayList();
        int i = 0;
        while (i < list.length) {
            DevicePlatformProvider provider = (DevicePlatformProvider)list[i];
            DevicePlatform[] devicePlatforms = provider.getDevicePlatforms();
            int c = 0;
            while (c < devicePlatforms.length) {
                DevicePlatform dp = devicePlatforms[c];
                if (devicePlatform.getVendor() != null && devicePlatform.getVendor().equals(dp.getVendor()) && devicePlatform.getVersion() != null && devicePlatform.getVersion().equals(dp.getVersion()) && devicePlatform.getName() != null && devicePlatform.getName().equals(dp.getName())) {
                    return provider;
                }
                ++c;
            }
            ++i;
        }
        throw new MtjException(Messages.DeviceManagementImpl_6);
    }
}

