/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.smgmt.sun.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.SecurityManagement;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.smgmt.sun.SmgmtPlugin;
import org.eclipse.mtj.extension.smgmt.sun.impl.Messages;

public class SecurityManagementImplementation
extends MtjExtensionImpl
implements SecurityManagement {
    private String storeType = "JKS";
    private String aliaskey = null;
    private String passwrd = null;
    private String keyStoreNameLoc = "";
    private String validity = "365";
    private IPreferenceStore securityProviderPrefStore;

    public SecurityManagementImplementation() {
        this.setId(SmgmtPlugin.getDefault().getBundle().getSymbolicName());
        this.setVendor(Messages.SecurityManagementImplementation_PluginVendor);
        this.setVersion(Messages.SecurityManagementImplementation_PluginVersion);
        this.setDescription(Messages.SecurityManagementImplementation_MTJ_Sun_Keytool);
        this.setType(ExtensionType.SECURITY_MANAGEMENT_LITERAL);
        this.securityProviderPrefStore = SmgmtPlugin.getDefault().getPreferenceStore();
    }

    public String[] openKeyStore(String keyStore, String storePass, IProgressMonitor monitor) throws MtjException {
        monitor.beginTask(Messages.SecurityManagementImplementation_Opening_key_store, 100);
        monitor.worked(10);
        String[] cmdArgs = this.generateOpenKeyStoreCmd(keyStore, storePass);
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                monitor.subTask(cmdOutput);
                monitor.worked(25);
                if (cmdOutput.toLowerCase().indexOf("error") >= 0) {
                    monitor.done();
                    if (cmdOutput.toLowerCase().indexOf("invalid keystore format") >= 0) {
                        throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20002)) + " :" + cmdOutput);
                    }
                    if (cmdOutput.toLowerCase().indexOf("password was incorrect") >= 0) {
                        throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20001)) + " :" + cmdOutput);
                    }
                    throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " :" + cmdOutput);
                }
                if (cmdOutput.indexOf(",") < 0) continue;
                StringTokenizer strtok = new StringTokenizer(cmdOutput, ".,");
                aliases.add(strtok.nextToken());
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    public String getStoreType() throws MtjException {
        return this.storeType;
    }

    public String getAliaskey() throws MtjException {
        return this.aliaskey;
    }

    public String getPassWrd() throws MtjException {
        return this.passwrd;
    }

    public String getKeyStoreNameLoc() throws MtjException {
        return this.keyStoreNameLoc;
    }

    public String getValidity() throws MtjException {
        return this.validity;
    }

    public void setStoreType(String storeType) throws MtjException {
        this.storeType = storeType;
    }

    public void setAliaskey(String aliasKey) throws MtjException {
        this.aliaskey = aliasKey;
    }

    public void setPassWrd(String passWrd) throws MtjException {
        this.passwrd = passWrd;
    }

    public void setKeyStoreNameLoc(String keyStoreNameLoc) throws MtjException {
        this.keyStoreNameLoc = keyStoreNameLoc;
    }

    public void setValidity(String validity) throws MtjException {
        this.validity = validity;
    }

    public void setValues(String loc, String alias, String psswd, String strtype) throws MtjException {
        this.storeType = strtype;
        this.aliaskey = alias;
        this.passwrd = psswd;
        this.keyStoreNameLoc = loc;
    }

    private String[] generateOpenKeyStoreCmd(String keyStore, String storePasswd) throws MtjException {
        String[] openKeyStoreCmdArgs = new String[]{this.getSecurityManagementTool(), SecurityManagementImplementation.getConsoleEncoding(), "-list", "-storetype", this.storeType, "-keystore", keyStore, "-storepass", storePasswd};
        return openKeyStoreCmdArgs;
    }

    private final String getSecurityManagementTool() throws MtjException {
        String securityToolLocation = this.getToolLocation(null);
        if (securityToolLocation == null || securityToolLocation.length() <= 0 || securityToolLocation.equals(Messages.PreferenceInitializer_0)) {
            String message = MessageFormat.format(Messages.SecurityManagementImplementation_0, this.getId(), Messages.SecurityManagementImplementation_Security_tool_not_configured_correctly, Messages.SecurityManagementImplementation_Security_tool_using_features);
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20003)) + "\n" + message);
        }
        StringBuffer buffer = new StringBuffer("\"");
        buffer.append(securityToolLocation).append(File.separator).append("bin").append(File.separator).append("keytool.exe").append("\"");
        return buffer.toString();
    }

    private static String getConsoleEncoding() {
        return "-J-Dconsole.encoding=" + System.getProperty("file.encoding");
    }

    private Process runSecurityCmd(String[] cmd) throws MtjException {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException iOException) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000));
        }
        if (p == null) {
            StringBuffer str = new StringBuffer("");
            int i = 0;
            while (i < cmd.length) {
                str.append(" " + cmd[i]);
                ++i;
            }
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + Messages.SecurityManagementImplementation_Could_not_execute + " [" + str + "]");
        }
        return p;
    }

    public boolean isKeyStoreSelected() throws MtjException {
        return this.keyStoreNameLoc != null && this.keyStoreNameLoc.length() > 0;
    }

    public boolean importSignedCert(String certFile, IProgressMonitor monitor) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateImportSignedCertCmd(certFile);
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.indexOf("error") < 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateImportSignedCertCmd(String certFile) throws MtjException {
        String[] importSignedCertCmdArgs = new String[]{this.getSecurityManagementTool(), SecurityManagementImplementation.getConsoleEncoding(), "-import", "-noprompt", "-alias", this.aliaskey, "-keypass", this.passwrd, "-file", certFile, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd};
        return importSignedCertCmdArgs;
    }

    public boolean generateCSR(String certFile, IProgressMonitor monitor) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateGenerateCSRCmd(certFile);
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.toLowerCase().indexOf("error") < 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateGenerateCSRCmd(String certFile) throws MtjException {
        String[] generateCSRCmdArgs = new String[]{this.getSecurityManagementTool(), SecurityManagementImplementation.getConsoleEncoding(), "-export", "-alias", this.aliaskey, "-file", certFile, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd};
        return generateCSRCmdArgs;
    }

    public boolean deleteKey(IProgressMonitor monitor) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateDeleteKeyCmd();
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.toLowerCase().indexOf("error") < 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateDeleteKeyCmd() throws MtjException {
        String[] deleteKeyCmdArgs = new String[]{this.getSecurityManagementTool(), SecurityManagementImplementation.getConsoleEncoding(), "-delete", "-alias", this.aliaskey, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd};
        return deleteKeyCmdArgs;
    }

    public boolean changeStorePassword(String newStorePass, String storePass, IProgressMonitor monitor) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateChangeStorePasswordCmd(newStorePass, storePass);
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.toLowerCase().indexOf("error") < 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateChangeStorePasswordCmd(String newStorePass, String storePasswd) throws MtjException {
        String[] changeStorePasswordCmdArgs = new String[]{this.getSecurityManagementTool(), SecurityManagementImplementation.getConsoleEncoding(), "-storepasswd", "-new", newStorePass, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", storePasswd};
        return changeStorePasswordCmdArgs;
    }

    public boolean createNewKey(String alias, String commonName, String orgUnit, String orgName, String localityName, String stateName, String country, IProgressMonitor monitor) throws MtjException {
        monitor.beginTask(Messages.SecurityManagementImplementation_Creating_key_alias, 100);
        boolean cmdSuccessful = true;
        String Dname = this.generateDname(commonName, orgUnit, orgName, localityName, stateName, country);
        String[] cmdArgs = this.generateNewKeyCmd(alias, Dname, "RSA", "SHA1withRSA");
        Process p = this.runSecurityCmd(cmdArgs);
        monitor.worked(30);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                monitor.worked(40);
                if (cmdOutput.toLowerCase().indexOf("error") < 0) continue;
                monitor.done();
                if (cmdOutput.toLowerCase().indexOf("alias <" + alias + "> already exists") >= 0) {
                    throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20004)) + " " + cmdOutput);
                }
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        monitor.worked(100);
        monitor.done();
        return cmdSuccessful;
    }

    private String[] generateNewKeyCmd(String alias, String dname, String keyAlg, String sigAlg) throws MtjException {
        String[] newKeyCmdArgs = new String[]{this.getSecurityManagementTool(), SecurityManagementImplementation.getConsoleEncoding(), "-genkey", "-alias", alias, "-dname", dname, "-keypass", this.passwrd, "-storetype", this.storeType, "-keyalg", keyAlg, "-sigalg", sigAlg, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd, "-validity", this.validity};
        return newKeyCmdArgs;
    }

    public String generateDname(String commonName, String orgUnit, String orgName, String localityName, String stateName, String country) {
        String Dname = "\"CN=" + commonName + ", " + "OU=" + orgUnit + ", " + "O=" + orgName + ", " + "L=" + localityName + ", " + "S=" + stateName + ", " + "C=" + country + "\"";
        return Dname;
    }

    public String getCertificateInfo(IProgressMonitor monitor) throws MtjException {
        String certInfo = "";
        if (this.aliaskey != null && this.aliaskey.length() > 0) {
            try {
                String cmdOutput;
                String[] cmdArgs = this.generateDisplayCertifcates();
                Process p = this.runSecurityCmd(cmdArgs);
                BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
                monitor.worked(20);
                while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                    if (cmdOutput.toLowerCase().indexOf("error") >= 0) {
                        throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
                    }
                    if (cmdOutput.length() < 0) continue;
                    certInfo = String.valueOf(certInfo) + cmdOutput;
                }
            }
            catch (IOException ee) {
                certInfo = "";
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
            }
            catch (Exception e) {
                certInfo = "";
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)e);
            }
        }
        return certInfo;
    }

    private String[] generateDisplayCertifcates() throws MtjException {
        String[] listCertificateCmdArgs = new String[]{this.getSecurityManagementTool(), SecurityManagementImplementation.getConsoleEncoding(), "-list", "-alias", this.aliaskey, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd};
        return listCertificateCmdArgs;
    }

    public String getToolLocation(IProgressMonitor monitor) throws MtjException {
        return this.securityProviderPrefStore.getString("SecurityToolLocationPreference");
    }

    public void storeToolLocation(String loc, IProgressMonitor monitor) throws MtjException {
        this.securityProviderPrefStore.setValue("SecurityToolLocationPreference", loc);
    }

    public void resetValues() {
    }
}

