/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.jadeditor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.debug.ui.launcher.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.extension.devide.jadeditor.AbstractJADEditorPage;
import org.eclipse.mtj.extension.devide.jadeditor.DescriptorPropertyDescription;
import org.eclipse.mtj.extension.devide.jadeditor.JADEditor;
import org.eclipse.mtj.extension.devide.jadeditor.ListDescriptorPropertyDescription;
import org.eclipse.mtj.extension.devide.jadeditor.ManifestPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class JADPropertiesEditorPage
extends AbstractJADEditorPage {
    private DescriptorPropertyDescription[] descriptors;
    private FieldEditor[] fieldEditors;

    public JADPropertiesEditorPage(JADEditor editor, String id, String title, DescriptorPropertyDescription[] descriptors) {
        super(editor, id, title);
        this.descriptors = descriptors;
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.setTaskName(this.getTitle());
        int i = 0;
        while (i < this.fieldEditors.length) {
            this.fieldEditors[i].store();
            ++i;
        }
        this.setDirty(false);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite composite = this.createSectionComposite(managedForm);
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0);
        new Label(composite, 0);
        this.fieldEditors = new FieldEditor[this.descriptors.length];
        int i = 0;
        while (i < this.descriptors.length) {
            switch (this.descriptors[i].getDataType()) {
                case 3: {
                    this.fieldEditors[i] = this.createIntegerFieldEditor(toolkit, composite, this.descriptors[i]);
                    break;
                }
                case 4: {
                    this.fieldEditors[i] = this.createComboFieldEditor(toolkit, composite, this.descriptors[i]);
                    break;
                }
                default: {
                    this.fieldEditors[i] = this.createStringFieldEditor(toolkit, composite, this.descriptors[i]);
                }
            }
            Label label = this.fieldEditors[i].getLabelControl(composite);
            toolkit.adapt((Control)label, false, false);
            this.fieldEditors[i].setPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("field_editor_value")) {
                        JADPropertiesEditorPage.this.setDirty(true);
                    }
                }
            });
            ++i;
        }
        this.updateEditComponents();
        this.addContextHelp(composite);
    }

    protected void addContextHelp(Composite c) {
    }

    public void setFocus() {
        if (this.fieldEditors.length > 0) {
            this.fieldEditors[0].setFocus();
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.updateEditComponents();
        this.setDirty(false);
    }

    private FieldEditor createComboFieldEditor(FormToolkit toolkit, Composite composite, DescriptorPropertyDescription description) {
        ListDescriptorPropertyDescription listDescription = (ListDescriptorPropertyDescription)description;
        ComboFieldEditor editor = new ComboFieldEditor(listDescription.getPropertyName(), listDescription.getDisplayName(), listDescription.getNamesAndValues(), composite);
        toolkit.adapt((Control)editor.getComboBoxControl(composite), true, true);
        return editor;
    }

    private IntegerFieldEditor createIntegerFieldEditor(FormToolkit toolkit, Composite parent, DescriptorPropertyDescription descriptor) {
        IntegerFieldEditor integerEditor = new IntegerFieldEditor(descriptor.getPropertyName(), descriptor.getDisplayName(), parent);
        toolkit.adapt((Control)integerEditor.getTextControl(parent), true, true);
        return integerEditor;
    }

    private StringFieldEditor createStringFieldEditor(FormToolkit toolkit, Composite parent, DescriptorPropertyDescription descriptor) {
        StringFieldEditor editor = new StringFieldEditor(descriptor.getPropertyName(), descriptor.getDisplayName(), parent);
        toolkit.adapt((Control)editor.getTextControl(parent), true, true);
        return editor;
    }

    private void updateEditComponents() {
        if (this.fieldEditors != null) {
            ManifestPreferenceStore store = this.getPreferenceStore();
            int i = 0;
            while (i < this.fieldEditors.length) {
                FieldEditor fieldEditor = this.fieldEditors[i];
                fieldEditor.setPreferenceStore((IPreferenceStore)store);
                fieldEditor.load();
                ++i;
            }
        }
    }

    protected String getSectionDescription() {
        return null;
    }

    protected String getSectionTitle() {
        return null;
    }

    void editorInputChanged() {
        this.updateEditComponents();
    }

    boolean isManagingProperty(String property) {
        boolean manages = false;
        int i = 0;
        while (i < this.descriptors.length) {
            DescriptorPropertyDescription desc = this.descriptors[i];
            if (property.equals(desc.getPropertyName())) {
                manages = true;
                break;
            }
            ++i;
        }
        return manages;
    }
}

