/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.library;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.library.config.LibrarySpecification;
import org.eclipse.mtj.core.version.Version;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MtjCoreLibraryPlugin
extends Plugin {
    public static final String LIBRARY_TYPE_CONFIGURATION = "configuration";
    public static final String LIBRARY_TYPE_PROFILE = "profile";
    public static final String LIBRARY_TYPE_SERVICE_API = "api";
    public static final String J2ME_LIBRARIES_ID = "libraries";
    private LibrarySpecification[] librarySpecs;
    private static MtjCoreLibraryPlugin plugin;

    public MtjCoreLibraryPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static MtjCoreLibraryPlugin getDefault() {
        return plugin;
    }

    public static List<String> processFile(File path) throws Exception {
        BasicEList entryList = new BasicEList();
        JarFile jarFile = new JarFile(path);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        JarEntry jarEntry = null;
        while (enumeration.hasMoreElements()) {
            jarEntry = enumeration.nextElement();
            if (!jarEntry.getName().endsWith(".class")) continue;
            entryList.add(jarEntry.getName());
        }
        return entryList;
    }

    public static boolean checkClassList(String packageString, String classListString, List<String> entryList) {
        if (packageString == null || classListString == null) {
            return false;
        }
        if (packageString.equals("") || classListString.equals("")) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(classListString, ",");
        boolean success = true;
        while (st.hasMoreTokens()) {
            String classString = st.nextToken();
            if (!success || entryList.contains(String.valueOf(packageString.replace('.', '/')) + "/" + classString + ".class")) continue;
            success = false;
            break;
        }
        return success;
    }

    public static List<LibrarySpecification> getCorrLibrarySpecifications(File libraryFile) throws CoreException {
        LibrarySpecification[] libs = MtjCoreLibraryPlugin.getLibrarySpecifications();
        BasicEList list = new BasicEList();
        try {
            List<String> entryList = MtjCoreLibraryPlugin.processFile(libraryFile);
            LibrarySpecification[] librarySpecificationArray = libs;
            int n = 0;
            int n2 = librarySpecificationArray.length;
            while (n < n2) {
                LibrarySpecification lib = librarySpecificationArray[n];
                if (lib.getType().equals(LIBRARY_TYPE_SERVICE_API)) {
                    boolean success;
                    String allPackagesString = lib.getPackages();
                    StringTokenizer st = new StringTokenizer(allPackagesString, ",");
                    boolean bl = allPackagesString == null ? false : (success = !allPackagesString.equals(""));
                    if (success) {
                        while (st.hasMoreTokens()) {
                            String packageFileList;
                            String packageString = st.nextToken();
                            success = MtjCoreLibraryPlugin.checkClassList(packageString, packageFileList = lib.getPackageFiles(packageString), entryList);
                            if (!success) break;
                        }
                    }
                    if (success) {
                        list.add(lib);
                        lib.setBinFile(libraryFile.getPath());
                    }
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static LibrarySpecification[] getLibrarySpecifications(File libraryFile, String libraryType) throws CoreException {
        LibrarySpecification[] libs = MtjCoreLibraryPlugin.getLibrarySpecifications();
        ArrayList<LibrarySpecification> list = new ArrayList<LibrarySpecification>();
        try {
            List<String> entryList = MtjCoreLibraryPlugin.processFile(libraryFile);
            LibrarySpecification[] librarySpecificationArray = libs;
            int n = 0;
            int n2 = librarySpecificationArray.length;
            while (n < n2) {
                LibrarySpecification lib = librarySpecificationArray[n];
                if (lib.getType().equals(libraryType)) {
                    boolean success;
                    String allPackagesString = lib.getPackages();
                    StringTokenizer st = new StringTokenizer(allPackagesString, ",");
                    boolean bl = allPackagesString == null ? false : (success = !allPackagesString.equals(""));
                    if (success) {
                        while (st.hasMoreTokens()) {
                            String packageFileList;
                            String packageString = st.nextToken();
                            success = MtjCoreLibraryPlugin.checkClassList(packageString, packageFileList = lib.getPackageFiles(packageString), entryList);
                            if (!success) break;
                        }
                    }
                    if (success) {
                        list.add(lib);
                        lib.setBinFile(libraryFile.getPath());
                    }
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LibrarySpecification[] ret = new LibrarySpecification[list.size()];
        int i = 0;
        while (i < list.size()) {
            ret[i] = (LibrarySpecification)list.get(i);
            ++i;
        }
        return ret;
    }

    public static LibrarySpecification[] getLibrarySpecifications() throws CoreException {
        MtjCoreLibraryPlugin plugin = MtjCoreLibraryPlugin.getDefault();
        if (plugin.librarySpecs == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(MtjCorePlugin.getId(), J2ME_LIBRARIES_ID);
            IConfigurationElement[] configElements = point.getConfigurationElements();
            plugin.librarySpecs = new LibrarySpecification[configElements.length];
            int i = 0;
            while (i < configElements.length) {
                plugin.librarySpecs[i] = MtjCoreLibraryPlugin.createComponentSpecification(configElements[i]);
                ++i;
            }
        }
        return plugin.librarySpecs;
    }

    private static LibrarySpecification createComponentSpecification(IConfigurationElement element) throws CoreException {
        String id = element.getAttribute("id");
        String type = element.getAttribute("type");
        String name = element.getAttribute("name");
        String label = element.getAttribute("label");
        String versionString = element.getAttribute("version");
        Version version = new Version(versionString);
        String binFile = element.getAttribute("binFile");
        String classEntry = element.getAttribute("classEntry");
        String sourceFile = element.getAttribute("sourceFile");
        String javadocFile = element.getAttribute("javadocFile");
        String fileNameList = element.getAttribute("fileNameList");
        String packagesList = element.getAttribute("packages");
        LibrarySpecification specification = new LibrarySpecification();
        specification.setIdentifier(id);
        specification.setType(type);
        specification.setName(name);
        specification.setLabel(label);
        specification.setVersion(version);
        specification.setClassEntry(classEntry);
        specification.setBinFile(binFile);
        specification.setSourceFile(sourceFile);
        specification.setJavadocFile(javadocFile);
        specification.setFileNameList(fileNameList);
        specification.setPackages(packagesList);
        StringTokenizer packagest = new StringTokenizer(packagesList, ",");
        while (packagest.hasMoreTokens()) {
            String packageString = packagest.nextToken();
            String fileListString = element.getAttribute(packageString);
            specification.setPackage(packageString, fileListString);
        }
        return specification;
    }
}

