/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.jad.util;

import org.eclipse.mtj.jad.util.PropertyLine;

public class MIDletDescriptor
extends PropertyLine {
    protected String name;
    protected String icon;
    protected String classname;

    MIDletDescriptor(String line) {
        this.setValue(line);
    }

    public MIDletDescriptor(String name, String icon, String classname) {
        this.setName(name);
        this.setIcon(icon);
        this.setClassname(classname);
        super.setValue(this.constructValue());
    }

    public String constructValue() {
        StringBuffer b = new StringBuffer();
        b.append(this.name).append(',');
        b.append(this.icon).append(',');
        b.append(this.classname);
        return b.toString();
    }

    public String[] getDescription() {
        return new String[]{this.name, this.icon, this.classname};
    }

    public void setValue(String value) {
        int comma1Index = value.indexOf(44);
        if (comma1Index != -1) {
            int comma2Index = value.indexOf(44, comma1Index + 1);
            this.setName(value.substring(0, comma1Index));
            this.setIcon(comma2Index > comma1Index + 1 ? value.substring(comma1Index + 1, comma2Index) : "");
            this.setClassname(value.substring(comma2Index + 1));
        }
        super.setValue(value);
    }

    public static MIDletDescriptor convertFrom(PropertyLine line) {
        MIDletDescriptor descriptor = null;
        if (line instanceof MIDletDescriptor) {
            descriptor = (MIDletDescriptor)line;
        } else {
            descriptor = new MIDletDescriptor(line.getValue());
            descriptor.setKey(line.getKey());
            descriptor.setLeadingComment(line.getLeadingComment());
        }
        return descriptor;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public void setClassname(String classname) {
        this.classname = classname.trim();
    }

    public void setIcon(String icon) {
        this.icon = icon.trim();
    }

    public void setName(String name) {
        this.name = name.trim();
    }
}

