/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.sp.wtk.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.SigningProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.api.signings.SigningCertificate;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.sp.wtk.SigningProviderPlugin;
import org.eclipse.mtj.extension.sp.wtk.impl.Messages;
import org.eclipse.mtj.jad.util.ConvertNativeToUTF8;
import org.eclipse.mtj.jad.util.JadFileDescriptor;

public class SigningProviderImpl
extends MtjExtensionImpl
implements SigningProvider {
    private IPreferenceStore sigingProviderPrefStore;
    private SigningCertificate targetSigningCertificate;

    public SigningProviderImpl() {
        this.setId(SigningProviderPlugin.getDefault().getBundle().getSymbolicName());
        this.setVendor("Eclipse.org");
        this.setVersion("1.0.0");
        this.setDescription(Messages.SigningProviderImpl_12);
        this.setType(ExtensionType.SIGNING_PROVIDER_LITERAL);
        this.sigingProviderPrefStore = SigningProviderPlugin.getDefault().getPreferenceStore();
    }

    public DeploymentType[] getSupportedTypes() throws MtjException {
        DeploymentType[] supportedDeploymentTypes = new DeploymentType[]{DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL};
        return supportedDeploymentTypes;
    }

    private boolean isSupported(Deployment deployment) throws MtjException {
        boolean supported = false;
        if (deployment instanceof MidletDeployment) {
            supported = true;
        }
        return supported;
    }

    public boolean sign(IMtjProject project, IFolder targetFolder, SigningCertificate certificates, IProgressMonitor monitor) throws MtjException {
        boolean success;
        block4: {
            success = false;
            this.targetSigningCertificate = certificates;
            try {
                Deployment deployment = project.getDeployment();
                monitor.beginTask(Messages.SigningProviderImpl_0, 100);
                if (this.isSupported(deployment)) {
                    String jadNameLoc = ((MidletDeployment)deployment).getJad().getAbsolutePath();
                    String jarNameLoc = ((MidletDeployment)deployment).getJar().getAbsolutePath();
                    this.clearTempFiles(jadNameLoc);
                    success = this.signMIDPApplication(jadNameLoc, jarNameLoc, monitor);
                    IFile JadFile = this.getProjectjadIFile(project);
                    if (JadFile != null) {
                        JadFile.refreshLocal(0, monitor);
                    }
                    break block4;
                }
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7015)) + " " + Messages.SigningProviderImpl_7);
            }
            catch (CoreException e) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e);
            }
        }
        monitor.done();
        return success;
    }

    private boolean clearTempFiles(String jadNameLoc) {
        boolean success = false;
        File tempfile = new File(String.valueOf(jadNameLoc) + "temp");
        if (tempfile.exists() && tempfile.canWrite()) {
            success = tempfile.delete();
        }
        return success;
    }

    public String getExtJar() {
        return null;
    }

    public void setExtJar(String value) {
    }

    public boolean unsign(IMtjProject project, IFolder targetFolder, IProgressMonitor monitor) throws MtjException {
        monitor.beginTask(Messages.SigningProviderImpl_8, 100);
        IFile JadFile = this.getProjectjadIFile(project);
        try {
            if (this.isSupported(project.getDeployment())) {
                if (JadFile == null) {
                    throw new MtjException(Messages.SigningProviderImpl_9);
                }
            } else {
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7015)) + " " + Messages.SigningProviderImpl_7);
            }
            JadFileDescriptor jadDescriptor = JadFileDescriptor.getDescriptor((IFile)JadFile);
            monitor.worked(20);
            jadDescriptor.removeProperty("MIDlet-Jar-RSA-SHA1");
            jadDescriptor.removeProperty("MIDlet-Certificate-1-1");
            monitor.worked(20);
            JadFile.setContents(ConvertNativeToUTF8.convertNativeToUTF8((InputStream)jadDescriptor.serialize()), true, true, null);
            monitor.worked(60);
            JadFile.refreshLocal(0, monitor);
        }
        catch (CoreException e2) {
            monitor.done();
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e2);
        }
        catch (IOException e) {
            monitor.done();
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e);
        }
        monitor.done();
        return true;
    }

    private boolean signMIDPApplication(String jadFile, String jarFile, IProgressMonitor monitor) throws MtjException {
        boolean success = false;
        monitor.worked(10);
        if (!this.addSignature(jadFile, jarFile)) {
            monitor.done();
            return false;
        }
        success = true;
        monitor.worked(20);
        if (this.addCertificate(jadFile)) {
            success = true;
            monitor.worked(20);
        }
        return success;
    }

    private boolean addSignature(String jadFile, String jarFile) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateSignMIDPApplicationCmd(jadFile, jarFile);
        Process p = this.runSPCmd(cmdArgs);
        BufferedReader cmdErrorStream = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String cmdError = "";
        try {
            cmdError = cmdErrorStream.readLine();
            if (cmdError != null) {
                while (cmdError.equals("")) {
                    cmdError = cmdErrorStream.readLine();
                }
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " : " + cmdError);
            }
            cmdSuccessful = this.overWriteOriginalFile(jadFile);
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateSignMIDPApplicationCmd(String jadFile, String jarFile) throws MtjException {
        String[] signMIDPApplicationCmdArgs = new String[]{"java", "-jar", this.getSigningTool(), "-addjarsig", "-jarfile", jarFile, "-keypass", this.targetSigningCertificate.getKeystorePassword(), "-alias", this.targetSigningCertificate.getAliasName(), "-keystore", this.targetSigningCertificate.getKeystore(), "-encoding", System.getProperty("file.encoding"), "-inputjad", jadFile, "-outputjad", String.valueOf(jadFile) + "temp"};
        return signMIDPApplicationCmdArgs;
    }

    private Process runSPCmd(String[] cmd) throws MtjException {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException iOException) {}
        if (p == null) {
            StringBuffer str = new StringBuffer("");
            int i = 0;
            while (i < cmd.length) {
                str.append(" " + cmd[i]);
                ++i;
            }
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " could not execute: " + "[" + str + "]");
        }
        return p;
    }

    private boolean overWriteOriginalFile(String fileName) throws MtjException {
        boolean success = false;
        File originalFile = new File(fileName);
        File tempfile = new File(String.valueOf(fileName) + "temp");
        if (originalFile.exists() && originalFile.canWrite() && tempfile.exists() && tempfile.canWrite()) {
            success = originalFile.delete();
            if (!success) {
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " " + Messages.SigningProviderImpl_3 + fileName);
            }
            success = tempfile.renameTo(originalFile);
            if (!success) {
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " " + Messages.SigningProviderImpl_4 + fileName + Messages.SigningProviderImpl_5 + fileName + "temp");
            }
        }
        return success;
    }

    private final String getSigningTool() throws MtjException {
        String signingToolLocation = this.getToolLocation(null);
        if (signingToolLocation == null) {
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " " + Messages.SigningProviderImpl_2);
        }
        StringBuffer buffer = new StringBuffer("\"");
        buffer.append(signingToolLocation).append(File.separator).append("bin").append(File.separator).append("JadTool.jar").append("\"");
        return buffer.toString();
    }

    public boolean isSigned(IMtjProject mtjProject, IFolder targetFolder, IProgressMonitor monitor) throws MtjException {
        boolean isSigned;
        block5: {
            isSigned = false;
            IFile JadFile = this.getProjectjadIFile(mtjProject);
            try {
                if (JadFile != null) {
                    JadFileDescriptor jadDescriptor = JadFileDescriptor.getDescriptor((IFile)JadFile);
                    if (jadDescriptor.getProperty(16) != null || jadDescriptor.getProperty(17) != null) {
                        isSigned = true;
                    }
                    break block5;
                }
                throw new MtjException(Messages.SigningProviderImpl_9);
            }
            catch (CoreException e2) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e2);
            }
            catch (IOException e) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e);
            }
        }
        return isSigned;
    }

    private IFile getProjectjadIFile(IMtjProject project) throws MtjException {
        IFile jadIFile = null;
        Deployment dp = null;
        try {
            dp = project.getDeployment();
        }
        catch (CoreException e) {
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.SigningProviderImpl_10, (Throwable)e);
        }
        if (dp.getType() == DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL) {
            try {
                jadIFile = project.getDeploymentFolder(null).getFile(((MidletDeployment)dp).getJad().getName());
            }
            catch (CoreException e) {
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.SigningProviderImpl_11, (Throwable)e);
            }
        }
        return jadIFile;
    }

    private boolean addCertificate(String jadFile) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateCertMIDPApplicationCmd(jadFile);
        Process p = this.runSPCmd(cmdArgs);
        BufferedReader cmdErrorStream = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String cmdError = "";
        try {
            cmdError = cmdErrorStream.readLine();
            if (cmdError != null) {
                while (cmdError.equals("")) {
                    cmdError = cmdErrorStream.readLine();
                }
                if (cmdError.toLowerCase().indexOf("keystore could not be loaded") >= 0) {
                    throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7001)) + " " + cmdError);
                }
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " : " + cmdError);
            }
            cmdSuccessful = this.overWriteOriginalFile(jadFile);
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateCertMIDPApplicationCmd(String jadFile) throws MtjException {
        String[] signMIDPApplicationCmdArgs = new String[]{"java", "-jar", this.getSigningTool(), "-addcert", "-alias", this.targetSigningCertificate.getAliasName(), "-keystore", this.targetSigningCertificate.getKeystore(), "-encoding", System.getProperty("file.encoding"), "-inputjad", jadFile, "-outputjad", String.valueOf(jadFile) + "temp"};
        return signMIDPApplicationCmdArgs;
    }

    public String getToolLocation(IProgressMonitor monitor) throws MtjException {
        return this.sigingProviderPrefStore.getString("ToolLocationPreference");
    }

    public void storeToolLocation(String loc, IProgressMonitor monitor) throws MtjException {
        this.sigingProviderPrefStore.setValue("ToolLocationPreference", loc);
    }

    public String[] listrootcert(String rootcert) throws MtjException {
        String[] cmdArgs = null;
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            String cmdOutput;
            cmdArgs = this.generateOpenRootCertCmd(rootcert);
            Process p = this.runSPCmd(cmdArgs);
            BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.indexOf("Key ") >= 0) {
                    StringBuffer cmds = new StringBuffer(cmdOutput);
                    int i = 0;
                    while (i <= 2) {
                        cmds.append(" ");
                        cmdOutput = cmdOutputStream.readLine();
                        if (cmdOutput != null) {
                            cmds.append(cmdOutput);
                        }
                        ++i;
                    }
                    aliases.add(cmds.toString());
                    continue;
                }
                if (cmdOutput.toLowerCase().indexOf("error") < 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)ee);
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    private String[] generateOpenRootCertCmd(String rootcert) throws MtjException {
        String[] newKeyCmdArgs = new String[]{"java", "-jar", this.getMESecurityManagementTool(), "-list", "-MEkeystore", rootcert};
        return newKeyCmdArgs;
    }

    public void importToRootCert(String rootcert, String keystore, String alias, String password) throws MtjException {
        String[] cmdArgs = null;
        cmdArgs = this.generateImportToRootCertCmd(rootcert, keystore, alias, password);
        Process p = this.runSPCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.length() == 0) continue;
                if (cmdOutput.toLowerCase().indexOf("Owner already has this key in the ME keystore") >= 0) {
                    throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20004)) + " " + cmdOutput);
                }
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
    }

    private String[] generateImportToRootCertCmd(String rootcert, String keystore, String alias, String password) throws MtjException {
        String[] importCertificateCmdArgs = new String[]{"java", "-jar", this.getMESecurityManagementTool(), "-import", "-MEkeystore", rootcert, "-keystore", keystore, "-storepass", password, "-alias", alias};
        return importCertificateCmdArgs;
    }

    public boolean isRootCertToolAvailable() throws MtjException {
        return this.getMESecurityManagementTool() != null;
    }

    private String getMESecurityManagementTool() throws MtjException {
        String securityToolLocation = this.getToolLocation(null);
        if (securityToolLocation == null || securityToolLocation.length() <= 0 || securityToolLocation.equals(Messages.PreferenceInitializer_0)) {
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7003)) + "\n" + this.getId() + Messages.SigningProviderImpl_19);
        }
        StringBuffer buffer = new StringBuffer("\"");
        buffer.append(securityToolLocation).append(File.separator).append("bin").append(File.separator).append("MEKeyTool.jar").append("\"");
        return buffer.toString();
    }

    public void removeCertFromRoot(String rootcert, int removeindex) throws MtjException {
        String[] cmdArgs = null;
        cmdArgs = this.generateDeleteFromRootCertCmd(rootcert, removeindex);
        Process p = this.runSPCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.length() == 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
    }

    private String[] generateDeleteFromRootCertCmd(String rootcert, int removeindex) throws MtjException {
        String[] removeCertificateCmdArgs = new String[]{"java", "-jar", this.getMESecurityManagementTool(), "-delete", "-MEkeystore", rootcert, "-number", Integer.toString(removeindex)};
        return removeCertificateCmdArgs;
    }
}

