/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.sp.impl.j9;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.SigningProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.api.signings.SigningCertificate;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.sp.impl.j9.Messages;
import org.eclipse.mtj.extension.sp.j9.J9SigningPlugin;
import org.eclipse.mtj.jad.util.ConvertNativeToUTF8;
import org.eclipse.mtj.jad.util.JadFileDescriptor;

public class J9SigningProvider
extends MtjExtensionImpl
implements SigningProvider {
    private IPreferenceStore sigingProviderPrefStore;
    private SigningCertificate targetSigningCertificate;

    public J9SigningProvider() {
        this.setId(J9SigningPlugin.getDefault().getBundle().getSymbolicName());
        this.setVendor(Messages.J9SigningProvider_PluginVendor);
        this.setVersion(Messages.J9SigningProvider_PluginVersion);
        this.setDescription(Messages.J9SigningProvider_15);
        this.setType(ExtensionType.SIGNING_PROVIDER_LITERAL);
        this.sigingProviderPrefStore = J9SigningPlugin.getDefault().getPreferenceStore();
    }

    public DeploymentType[] getSupportedTypes() throws MtjException {
        DeploymentType[] supportedDeploymentTypes = new DeploymentType[]{DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL};
        return supportedDeploymentTypes;
    }

    private boolean isSupported(Deployment deployment) throws MtjException {
        boolean supported = false;
        if (deployment instanceof MidletDeployment) {
            supported = true;
        }
        return supported;
    }

    public boolean sign(IMtjProject project, IFolder targetFolder, SigningCertificate certificates, IProgressMonitor monitor) throws MtjException {
        boolean cmdSuccessful;
        block4: {
            cmdSuccessful = false;
            monitor.beginTask(Messages.J9SigningProvider_0, 4);
            this.targetSigningCertificate = certificates;
            try {
                Deployment deployment = project.getDeployment();
                if (this.isSupported(deployment)) {
                    String jadNameLoc = ((MidletDeployment)deployment).getJad().getAbsolutePath();
                    String jarNameLoc = ((MidletDeployment)deployment).getJar().getAbsolutePath();
                    cmdSuccessful = this.signMIDPApplication(jadNameLoc, jarNameLoc, monitor);
                    IFile JadFile = this.getProjectjadIFile(project);
                    if (JadFile != null) {
                        JadFile.refreshLocal(0, monitor);
                    }
                    break block4;
                }
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7015)) + " " + Messages.J9SigningProvider_6);
            }
            catch (CoreException e) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e);
            }
        }
        monitor.done();
        return cmdSuccessful;
    }

    private boolean signMIDPApplication(String jadFile, String jarFile, IProgressMonitor monitor) throws MtjException {
        boolean success = true;
        monitor.beginTask(Messages.J9SigningProvider_7, 100);
        String cmdError = "";
        try {
            String[] cmdArgs = this.generateSignApplicationCmd(jadFile);
            Process p = this.runMIDPSecurityCmd(cmdArgs);
            monitor.worked(40);
            BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((cmdError = cmdOutputStream.readLine()) != null) {
                String errorMessage = Messages.J9SigningProvider_1;
                if (cmdError.toLowerCase().indexOf(errorMessage.toLowerCase()) < 0) continue;
                monitor.done();
                if (cmdError.toLowerCase().indexOf("invalid keystore") >= 0) {
                    throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7001)) + " " + cmdError);
                }
                if (cmdError.toLowerCase().indexOf("keystore not found") >= 0) {
                    throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7016)) + " " + cmdError);
                }
                if (cmdError.toLowerCase().indexOf("Incorrect password") >= 0) {
                    throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7007)) + " " + cmdError);
                }
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " " + cmdError);
            }
        }
        catch (IOException e) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e);
        }
        monitor.done();
        return success;
    }

    public boolean unsign(IMtjProject project, IFolder targetFolder, IProgressMonitor monitor) throws MtjException {
        monitor.beginTask(Messages.J9SigningProvider_8, 100);
        IFile JadFile = this.getProjectjadIFile(project);
        try {
            if (this.isSupported(project.getDeployment())) {
                if (JadFile == null) {
                    throw new MtjException(Messages.J9SigningProvider_9);
                }
            } else {
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7015)) + " " + Messages.J9SigningProvider_6);
            }
            JadFileDescriptor jadDescriptor = JadFileDescriptor.getDescriptor((IFile)JadFile);
            monitor.worked(20);
            jadDescriptor.removeProperty("MIDlet-Jar-RSA-SHA1");
            jadDescriptor.removeProperty("MIDlet-Certificate-1-1");
            monitor.worked(20);
            JadFile.setContents(ConvertNativeToUTF8.convertNativeToUTF8((InputStream)jadDescriptor.serialize()), true, true, null);
            monitor.worked(60);
            JadFile.refreshLocal(0, monitor);
        }
        catch (CoreException e2) {
            monitor.done();
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e2);
        }
        catch (IOException e) {
            monitor.done();
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e);
        }
        monitor.done();
        return true;
    }

    public boolean isSigned(IMtjProject mtjProject, IFolder targetFolder, IProgressMonitor monitor) throws MtjException {
        boolean isSigned;
        block5: {
            isSigned = false;
            IFile JadFile = this.getProjectjadIFile(mtjProject);
            try {
                if (JadFile != null) {
                    JadFileDescriptor jadDescriptor = JadFileDescriptor.getDescriptor((IFile)JadFile);
                    if (jadDescriptor.getProperty(16) != null || jadDescriptor.getProperty(17) != null) {
                        isSigned = true;
                    }
                    break block5;
                }
                throw new MtjException(Messages.J9SigningProvider_12);
            }
            catch (CoreException e2) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e2);
            }
            catch (IOException e) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)e);
            }
        }
        return isSigned;
    }

    private IFile getProjectjadIFile(IMtjProject project) throws MtjException {
        IFile jadIFile = null;
        Deployment dp = null;
        try {
            dp = project.getDeployment();
        }
        catch (CoreException e) {
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.J9SigningProvider_13, (Throwable)e);
        }
        if (dp.getType() == DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL) {
            try {
                jadIFile = project.getDeploymentFolder(null).getFile(((MidletDeployment)dp).getJad().getName());
            }
            catch (CoreException e) {
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.J9SigningProvider_14, (Throwable)e);
            }
        }
        return jadIFile;
    }

    public String getToolLocation(IProgressMonitor monitor) throws MtjException {
        return this.sigingProviderPrefStore.getString("J9SignToolLocationPreference");
    }

    public void storeToolLocation(String loc, IProgressMonitor monitor) throws MtjException {
        this.sigingProviderPrefStore.setValue("J9SignToolLocationPreference", loc);
    }

    public String getExtJar() {
        return null;
    }

    public void setExtJar(String value) {
    }

    private String[] generateSignApplicationCmd(String jadFile) throws MtjException {
        String[] signMIDPApplicationCmdArgs = new String[]{this.getJadSignerLocation(), "-sign", "-keystore", this.targetSigningCertificate.getKeystore(), "-storepass", this.targetSigningCertificate.getKeystorePassword(), "-alias", this.targetSigningCertificate.getAliasName(), "-keypass", this.targetSigningCertificate.getCertificatePassword(), "-jad", jadFile};
        return signMIDPApplicationCmdArgs;
    }

    private final String getJadSignerLocation() throws MtjException {
        String signingToolLocation = this.getToolLocation(null);
        if (signingToolLocation == null) {
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + Messages.J9SigningProvider_4);
        }
        StringBuffer buffer = new StringBuffer("\"");
        buffer.append(signingToolLocation).append(File.separator).append("bin").append(File.separator).append("jadsigner.exe").append("\"");
        return buffer.toString();
    }

    private Process runMIDPSecurityCmd(String[] cmd) throws MtjException {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception exception) {}
        if (p == null) {
            StringBuffer str = new StringBuffer("");
            int i = 0;
            while (i < cmd.length) {
                str.append(" " + cmd[i]);
                ++i;
            }
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " could not execute: " + "[" + str + "]");
        }
        return p;
    }

    public String[] listrootcert(String rootcert) throws MtjException {
        String[] cmdArgs = null;
        ArrayList<String> aliases = new ArrayList<String>();
        cmdArgs = this.generateOpenRootCertCmd(rootcert);
        Process p = this.runMIDPSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.indexOf("Trusted Certificate #") < 0) continue;
                StringBuffer cmds = new StringBuffer(cmdOutput);
                int i = 0;
                while (i <= 5) {
                    cmds.append(" ");
                    cmdOutput = cmdOutputStream.readLine();
                    if (cmdOutput != null) {
                        if (cmdOutput.equals("")) break;
                        cmds.append(cmdOutput);
                    }
                    ++i;
                }
                aliases.add(cmds.toString());
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)7000), (Throwable)ee);
        }
        if (aliases.isEmpty()) {
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7000)) + " Root certificate is empty or invalid");
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    private String[] generateOpenRootCertCmd(String rootcert) throws MtjException {
        String[] newKeyCmdArgs = new String[]{this.getMESecurityManagementTool(), "-list", "-MEkeystore", rootcert};
        return newKeyCmdArgs;
    }

    public void importToRootCert(String rootcert, String keystore, String alias, String password) throws MtjException {
        String[] cmdArgs = null;
        cmdArgs = this.generateImportToRootCertCmd(rootcert, keystore, alias, password);
        Process p = this.runMIDPSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.length() == 0) continue;
                if (cmdOutput.toLowerCase().indexOf("already exists in keystore") >= 0) {
                    throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20004)) + " " + cmdOutput);
                }
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
    }

    private String[] generateImportToRootCertCmd(String rootcert, String keystore, String alias, String password) throws MtjException {
        String[] importCertificateCmdArgs = new String[]{this.getMESecurityManagementTool(), "-import", "-MEkeystore", rootcert, "-alias", alias, "-keystore", keystore, "-storepass", password};
        return importCertificateCmdArgs;
    }

    public boolean isRootCertToolAvailable() throws MtjException {
        return this.getMESecurityManagementTool() != null;
    }

    private String getMESecurityManagementTool() throws MtjException {
        String securityToolLocation = this.getToolLocation(null);
        if (securityToolLocation == null || securityToolLocation.length() <= 0 || securityToolLocation.equals(Messages.J9SigningProviderPrefInitializer_0)) {
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)7003)) + "\n" + this.getId() + Messages.J9SigningProvider_19);
        }
        StringBuffer buffer = new StringBuffer("\"");
        buffer.append(securityToolLocation).append(File.separator).append("bin").append(File.separator).append("MEkeytool.exe").append("\"");
        return buffer.toString();
    }

    public void removeCertFromRoot(String rootcert, int removeindex) throws MtjException {
        String[] cmdArgs = null;
        cmdArgs = this.generateDeleteFromRootCertCmd(rootcert, removeindex);
        Process p = this.runMIDPSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.length() == 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
    }

    private String[] generateDeleteFromRootCertCmd(String rootcert, int removeindex) throws MtjException {
        String[] removeCertificateCmdArgs = new String[]{this.getMESecurityManagementTool(), "-delete", "-MEkeystore", rootcert, "-number", Integer.toString(removeindex)};
        return removeCertificateCmdArgs;
    }
}

