package org.eclipse.mtj.extension.rpm.model;

import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.core.ui.util.CompositeDialog;
import org.eclipse.mtj.core.ui.util.CompositePrototype;
import org.eclipse.mtj.extension.rpm.Messages;
import org.eclipse.mtj.extension.rpm.preferences.ModifyDeviceController;
import org.eclipse.mtj.extension.rpm.preferences.ModifyRuntimeController;
import org.eclipse.mtj.extension.rpm.ui.preferences.ModifyDeviceComposite;
import org.eclipse.mtj.extension.rpm.ui.preferences.ModifyRuntimeComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RpmUIManager {
	private static final Shell containerShell = new Shell();
	private static final MtjServiceHandler mtjServiceHandler = new MtjServiceHandler();
	
	public static void editDevicePlatform(RuntimePlatform rp, Composite parent) {
		class composite implements CompositePrototype {
			private ModifyDeviceController controller;
			private ModifyDeviceComposite c;
			
			public composite(RuntimePlatform runtimePlatform) {
				this.c = new ModifyDeviceComposite(containerShell);
				this.controller = new ModifyDeviceController(c, new MtjServiceHandler(), runtimePlatform);										
			}
			
			public Composite clone() {
				return c;
			}
			
			public ModifyDeviceController getController() {
				return controller;
			}
		}

		composite c = new composite(rp);
		CompositeDialog d = new CompositeDialog(parent.getShell(), 
				c, c.getController(),
				Messages.RpmUIManager_RuntimePlatformTitle,
				Messages.RpmUIManager_EditDevice,
				Messages.RpmUIManager_ConfigureAndEditDeviceSettings);
		d.open();
	}
	
	
	public static int editRuntimePlatform(RuntimePlatform rp, Composite parent) {
		return editRuntimePlatform(rp, null, parent.getShell());	
	}

	public static int editRuntimePlatform(RuntimePlatform rp, RuntimePlatform[] platforms, Composite parent) {
		return editRuntimePlatform(rp, platforms, parent.getShell());
	}
	public static int editRuntimePlatform(RuntimePlatform rp, RuntimePlatform[] platforms, Shell parent) {
		class composite implements CompositePrototype {
			private ModifyRuntimeController controller;
			private ModifyRuntimeComposite c;
			
			public composite(RuntimePlatform runtimePlatform, RuntimePlatform[] platforms) {
				this.c = new ModifyRuntimeComposite(containerShell);	
				this.controller = new ModifyRuntimeController(c, platforms != null ? platforms : mtjServiceHandler.getRuntimePlatforms(), mtjServiceHandler, runtimePlatform, false);										
			}
			
			public Composite clone() {
				return c;
			}
			
			public ModifyRuntimeController getController() {
				return controller;
			}
		}

		composite c = new composite(rp, platforms);
		CompositeDialog d = new CompositeDialog(parent, 
				c, c.getController(),
				Messages.RpmUIManager_RuntimePlatformTitle,
				Messages.RpmUIManager_EditRuntimePlatform,
				Messages.RpmUIManager_ConfigureAndEditRuntimePlatformSettings);
		return d.open();
	}

	public static int addRuntimePlatform(Shell parent, boolean write) {
		return addRuntimePlatform(parent, mtjServiceHandler.getRuntimePlatforms(), mtjServiceHandler, write);
	}
	
	public static int addRuntimePlatform(Shell parent, RuntimePlatform[] platforms, MtjServiceHandler mtjServiceHandler, boolean write) {
		class composite implements CompositePrototype {
			private ModifyRuntimeController controller;
			private ModifyRuntimeComposite c;
			private boolean write;
						
			public composite(MtjServiceHandler mtjServiceHandler, RuntimePlatform[] platforms, boolean write) {
				this.c = new ModifyRuntimeComposite(containerShell);	
				this.controller = new ModifyRuntimeController(c, platforms, mtjServiceHandler, write);										
				this.write = write;
			}
			
			public Composite clone() {
				return c;
			}
			
			public ModifyRuntimeController getController() {
				return controller;
			}
		}

		composite c = new composite(mtjServiceHandler, platforms, write);
		CompositeDialog d = new CompositeDialog(parent, 
				c, c.getController(),
				Messages.RpmUIManager_RuntimePlatformTitle,
				Messages.RpmUIManager_AddRuntimePlatform,
				Messages.RpmUIManager_ProvideNameDescriptionAndDevicePlatform);
		int value = d.open();	
		return value;
	}
}
