/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - initial API and implementation
 *******************************************************************************/

package org.eclipse.mtj.extension.smgmt.ui.actions;


import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class CreateKeyDialog extends Dialog{


	private Text Alias;
	private Text CommonName;
	private Text OrgUnit;
	private Text OrgName;
	private Text LocalName;
	private Text StateName;
	private Text Country;
	
	private String fAlias;
	private String fCommonName;
	private String fOrgUnit;
	private String fOrgName;
	private String fLocalName;
	private String fStateName;
	private String fCountry;
	

/**
	 * @param arg0
	 */
	protected CreateKeyDialog(Shell arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
	 */
	protected void createButtonsForButtonBar(Composite parent) {
		
		createButton(parent, IDialogConstants.OK_ID, SecurityManagmentUIMessages.CreateKeyDialog_Create_1, true); 
		createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
		getButton(IDialogConstants.OK_ID).setEnabled(false);
		
		//super.createButtonsForButtonBar(parent);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#buttonPressed(int)
	 */
	protected void buttonPressed(int buttonId) {
		if (buttonId == OK) {
			setFStateName(StateName.getText());
			setFOrgUnit(OrgUnit.getText());
			setFOrgName(OrgName.getText());
			setFLocalName(LocalName.getText());
			setFCountry(Country.getText());
			setFCommonName(CommonName.getText());
			setFAlias(Alias.getText());
			super.buttonPressed(buttonId);

		} else { 
				super.buttonPressed(buttonId);
		}
	}
	
	protected Control createDialogArea(Composite parent) {
		
		String title = SecurityManagmentUIMessages.CreateKeyDialog_New_Key_Pair_2; 
		parent.getShell().setText(title);
		
		Composite c1 =	new Composite(parent, SWT.NONE);
		
		GridLayout c1gridLayout = new GridLayout();
		c1gridLayout.numColumns = 6;
		c1.setLayout(c1gridLayout);
		GridData gdC = new GridData(GridData.FILL_HORIZONTAL);
		c1.setLayoutData(gdC);
		
		Label alias = new Label(c1, SWT.LEFT);
		alias.setText(SecurityManagmentUIMessages.CreateKeyDialog_Alias__3); 
		GridData gd = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 5;
		gd.widthHint = 150;
		Alias = new Text(c1, SWT.SINGLE | SWT.BORDER);
		Alias.setLayoutData(gd);
		Alias.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (getFStatus() == true){
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				}
			}
		});

		Label cn = new Label(c1, SWT.LEFT);
		cn.setText(SecurityManagmentUIMessages.CreateKeyDialog_Common_Name__4); 
		CommonName = new Text(c1, SWT.SINGLE | SWT.BORDER);
		GridData gd1 = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd1.horizontalSpan = 5;
		gd1.widthHint = 150;
		CommonName.setLayoutData(gd1);
		CommonName.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (getFStatus() == true){
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				}
			}
		});
		
		Label ou = new Label(c1, SWT.LEFT);
		ou.setText(SecurityManagmentUIMessages.CreateKeyDialog_Organizational_Unit__5); 
		OrgUnit = new Text(c1, SWT.SINGLE | SWT.BORDER);
		GridData gd2 = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd2.horizontalSpan = 5;
		gd2.widthHint = 150;
		OrgUnit.setLayoutData(gd2);
		OrgUnit.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (getFStatus() == true){
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				}
			}
		});
		
		Label on = new Label(c1, SWT.LEFT);
		on.setText(SecurityManagmentUIMessages.CreateKeyDialog_Organizational_Name__6); 
		OrgName = new Text(c1, SWT.SINGLE | SWT.BORDER);
		GridData gd3 = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd3.horizontalSpan = 5;
		gd3.widthHint = 150;
		OrgName.setLayoutData(gd3);
		OrgName.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (getFStatus() == true){
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				}
			}
		});
		
		Label ln = new Label(c1, SWT.LEFT);
		ln.setText(SecurityManagmentUIMessages.CreateKeyDialog_Locality_Name__7); 
		LocalName = new Text(c1, SWT.SINGLE | SWT.BORDER);
		GridData gd4 = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd4.horizontalSpan = 5;
		gd4.widthHint = 150;
		LocalName.setLayoutData(gd4);
		LocalName.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (getFStatus() == true){
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				}
			}
		});
		
		Label sn = new Label(c1, SWT.LEFT);
		sn.setText(SecurityManagmentUIMessages.CreateKeyDialog_State_Name__8); 
		StateName = new Text(c1, SWT.SINGLE | SWT.BORDER);
		GridData gd5 = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd5.horizontalSpan = 5;
		gd5.widthHint = 150;
		StateName.setLayoutData(gd5);
		StateName.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (getFStatus() == true){
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				}
			}
		});
		
		Label ct = new Label(c1, SWT.LEFT);
		ct.setText(SecurityManagmentUIMessages.CreateKeyDialog_Country__9); 
		Country = new Text(c1, SWT.SINGLE | SWT.BORDER);
		GridData gd6 = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd6.horizontalSpan = 5;
		gd6.widthHint = 150;
		Country.setLayoutData(gd6);
		Country.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (getFStatus() == true){
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				}
			}
		});

		return parent;
	}

	public boolean getFStatus(){
		
		if ((Alias.getText().trim().length() == 0) ||
			(CommonName.getText().trim().length() == 0) ||
			(OrgUnit.getText().trim().length() == 0) ||
			(OrgName.getText().trim().length() == 0) ||
			(LocalName.getText().trim().length() == 0) ||
			(StateName.getText().trim().length() == 0) ||
			(Country.getText().trim().length() == 0))
			{
				return false;				
		}
		else{
			return true;
		}
	}
	
	/**
	 * @return
	 */
	public String getFAlias() {
		return fAlias;
	}

	/**
	 * @return
	 */
	public String getFCommonName() {
		return fCommonName;
	}

	/**
	 * @return
	 */
	public String getFCountry() {
		return fCountry;
	}

	/**
	 * @return
	 */
	public String getFLocalName() {
		return fLocalName;
	}

	/**
	 * @return
	 */
	public String getFOrgName() {
		return fOrgName;
	}

	/**
	 * @return
	 */
	public String getFOrgUnit() {
		return fOrgUnit;
	}

	/**
	 * @return
	 */
	public String getFStateName() {
		return fStateName;
	}

	/**
	 * @param string
	 */
	public void setFAlias(String string) {
		fAlias = string;
	}

	/**
	 * @param string
	 */
	public void setFCommonName(String string) {
		fCommonName = string;
	}

	/**
	 * @param string
	 */
	public void setFCountry(String string) {
		fCountry = string;
	}

	/**
	 * @param string
	 */
	public void setFLocalName(String string) {
		fLocalName = string;
	}

	/**
	 * @param string
	 */
	public void setFOrgName(String string) {
		fOrgName = string;
	}

	/**
	 * @param string
	 */
	public void setFOrgUnit(String string) {
		fOrgUnit = string;
	}

	/**
	 * @param string
	 */
	public void setFStateName(String string) {
		fStateName = string;
	}

}	



