/*******************************************************************************
 * IBM Confidential
 * @RDD_PID@
 * OCO Source Materials
 * (C) Copyright IBM Corp. 1998, 2005.
 * The source code for this program is not published or otherwise divested
 * of its trade secrets, irrespective of what has been deposited with the
 * U.S. Copyright Office.
 *******************************************************************************/

/*
 * Created on Mar 23, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

package org.eclipse.mtj.extension.smgmt.ui.actions;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;


/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TreeDialog extends Dialog {
	String itemText;

	/**
	 * @param arg0
	 */
	public TreeDialog(Shell arg0) {
		super(arg0);
		// Auto-generated constructor stub
	}
	
	protected Control createButtonBar(Composite parent) {
		Control c = super.createButtonBar(parent);
		return c;
	}
	

	protected Control createDialogArea(Composite parent) {
		
		//Composite dialogArea = (Composite)super.createDialogArea(parent);
		String title = SecurityManagmentUIMessages.TreeDialog_Add_Permissions_1;  
		parent.getShell().setText(title);
				
		Composite mt = new Composite(parent, SWT.NONE);
		GridLayout hg1 = new GridLayout();
		mt.setLayout(hg1);
		mt.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
		Group grp1 = new Group(mt, SWT.None);
		GridLayout gl1 = new GridLayout();
		gl1.numColumns = 1;
		grp1.setLayout(gl1);
		grp1.setText(SecurityManagmentUIMessages.TreeDialog_Select_permissions_to_add__2);
		grp1.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
		//hg1.numColumns = 1;
		hg1.marginHeight = 10;
		
		final Tree tr = new Tree(grp1,SWT.SINGLE);
		tr.addSelectionListener(new SelectionAdapter() {
		public void widgetSelected(SelectionEvent e) {
			TreeItem [] sel = tr.getSelection();
			itemText = sel[0].getText();
			
			TreeItem me = sel[0].getParentItem();

			while (me != null){
				String tem = me.getText();
				itemText = tem + '.' + itemText;
				me = me.getParentItem();
			}
				
			}
		});
		
		try {

			InputStream rt = TreeDialog.class.getResourceAsStream("security.policy"); //$NON-NLS-1$
			BufferedReader in = new BufferedReader(new InputStreamReader(rt));

			String content;

			while ((content=in.readLine()) != null)
			{
				if (content.indexOf(".") != -1) //$NON-NLS-1$
				{
					// Added in the comma here to parse that out from the input file
					StringTokenizer strtok = new StringTokenizer(content, ".,"); //$NON-NLS-1$

					TreeItem ti = null;
					
					while (strtok.hasMoreTokens()) 
					{
						TreeItem[] items = null;
						TreeItem newItem = null;
						int index;
						String nodeText = strtok.nextToken().trim();
						// Added this to account for the extra empty token after the trailing comma 
						if (nodeText.length() == 0) {
							// Don't add empty tree nodes
							continue;
						}
						if (ti == null) {
							// At the top of the tree, start from the root
							items = tr.getItems();
							if (items != null) {
								// search for matching item
								for (index=0 ; index < items.length ; index++) {
									String itemText = items[index].getText();
									if (nodeText.compareTo(itemText) == 0) {
										newItem = items[index];
										break;
									}
								}
							}
							if (newItem == null) {
								// Add root item
								newItem = new TreeItem(tr, SWT.NONE);
								newItem.setText(nodeText);
							}
						} else {
							// Search current tree level
							items = ti.getItems();
							if (items != null) {
								// search for matching item
								for (index=0 ; index < items.length ; index++) {
									String itemText = items[index].getText();
									if (nodeText.compareTo(itemText) == 0) {
										newItem = items[index];
										break;
									}
								}
							}
							if (newItem == null) {
								// Add tree item
								newItem = new TreeItem(ti, SWT.NONE);
								newItem.setText(nodeText);
							}
						}
						ti = newItem;				
					}
				}
			}
		} 
		catch (FileNotFoundException e) {
		} 
		catch (IOException e) {
		}			

		GridData G = new GridData(GridData.FILL_BOTH);
		G.heightHint = 200;	
		G.widthHint = 200;
		tr.setLayoutData(G);
		
		return parent;
	}

	/*
 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
 */
protected void okPressed() {
	
	super.okPressed();
}

protected String ValueSelected (){

	return itemText;
}

}		


