/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
 * Additional Contributors -
 *  	Kevin Horowitz (IBM Corp) - Update javadoc
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.exception.MtjException;

/**
 * The Deployment Provider is responsible to deploy resources to target Devices. 
 * 
 */
public interface DeploymentProvider extends MtjExtension {

	/**
	 * Return DeploymentProvider's name
	 * 
	 * @return
	 */
	public String getName();
		
	/**
	 * Returns a list of device objects that are possible deployment targets. 
	 *
	 * @return
	 */
	public Device[] getDevices() throws MtjException;

	/**
	 * Returns target implementation type. 
	 * 
	 * @return
	 */
	public PlatformType getPlatformType() throws MtjException;

	/**
	 * Defines transfer protocols that are supported by the Deployment Provider.
	 *
	 * @return 
	 */
	public DeviceCommunicationProtocol[] getSupportedProtocols() throws MtjException;

	/**
	 * Deploys the deployment object to the target devices by using the defined transfer protocol.
	 * If transfer protocol parameter has null value, default transfer protocol is used.
	 * 
	 * @param deployment
	 * @param devices
	 * @param transferProtocol
	 * @param monitor
	 */
	public void deploy(Deployment deployment, Device[] devices,
			DeviceCommunicationProtocol transferProtocol,
			IProgressMonitor monitor) throws MtjException;

	/**
	 * Returns Device's status.
	 * 
	 * @param device
	 * @return
	 * @throws MtjException
	 */
	public DeviceStatus getStatus(Device device) throws MtjException;

}
