/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 * Additional Contributors -
 *  	Kevin Horowitz (IBM Corp) - Update javadoc
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import java.util.Properties;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.exception.MtjException;

/**
 * The PackagingProvider is responsible to create a deployment packages from application projects resources.
 */
public interface PackagingProvider extends BuildExtension {

	/**
	 * Returns the deployment types that are supported by the provider.
	 * 
	 * @return
	 */
	public DeploymentType[] getSupportedTypes() throws MtjException;

	/**
	 * Method creates deployment package from the resources.
	 * The Deployment result depends on the deployment type. 
	 * Created deployments are created to folder that is defined by targetFolder attribute. 
	 * 
	 * @param projectName
	 * @param projectData
	 * @param resources
	 * @param targetFolder
	 * @param type
	 * @param natureId
	 * @param monitor
	 * @return
	 */
	public Deployment createDeployment(String projectName, Project projectData, IResource[] resources,
			IFolder targetFolder, DeploymentType type, String natureId, IProgressMonitor monitor) throws MtjException;

	/**
	 * This provides an interface to set the project properties (application descriptor properties) for a MIDlet.
	 * @param midletProperties
	 */
	public void setMidletProperties(Properties midletProperties);
}
