/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.mtj.exception.MtjException;

/**
 * Implementor of this extension point provides persistent services to the Emf Model data.
 * 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:20 $
 * <br>
 */
public interface PersistentStoreProvider {

	public static final int DATA_TYPE_EMF = 0;
	
	/**
	 * This method persists data.
	 * 
	 * @param data
	 * @param dataType
	 * @param dataExtension
	 * @param ownerPluginName
	 * @param dataKey
	 */
	public void store(Object data, int dataType, String dataExtension, String ownerPluginName, String dataKey ) throws MtjException;
	
	/**
	 * This method persists data.
	 * 
	 * @param data
	 * @param dataType
	 * @param dataExtension
	 * @param fileName
	 */
	public void store(Object data, int dataType, String dataExtension, String fileName ) throws MtjException;
	
	/**
	 * This method returns persisted data.
	 * 
	 * @param dataType
	 * @param dataExtension
	 * @param ownerPluginName
	 * @param dataKey
	 * @return
	 */
	public Object get(int dataType, String dataExtension, String ownerPluginName, String dataKey ) throws MtjException;
	
	/**
	 * This method returns persisted data.
	 * 
	 * @param dataType
	 * @param dataExtension
	 * @param fileName
	 * @return
	 */
	public Object get(int dataType, String dataExtension, String fileName ) throws MtjException;
	
}
