/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 
package org.eclipse.mtj.internal.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

import org.eclipse.mtj.core.Messages;

/**
 * JarOutputStream subclass capable of tracking and checking
 * existence of entries that have been made.
 * <p />
 * Copyright (c) 2004 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.2 $
 * <br>
 * $Date: 2006/09/07 13:56:26 $
 * <br>
 * @author Craig Setera
 */

public class EntryTrackingJarOutputStream extends JarOutputStream {

	/**
	 * 
	 * @uml.property name="addedEntryNames"
	 * @uml.associationEnd 
	 * @uml.property name="addedEntryNames" multiplicity="(0 -1)" elementType="java.lang.String"
	 */
	private Set addedEntryNames = new HashSet();

	
	/**
	 * Create a new instance.
	 * 
	 * @param out
	 * @throws java.io.IOException
	 */
	public EntryTrackingJarOutputStream(OutputStream out) throws IOException {
		super(out);
	}

	/**
	 * Create a new instance.
	 * 
	 * @param out
	 * @param man
	 * @throws java.io.IOException
	 */
	public EntryTrackingJarOutputStream(OutputStream out, Manifest man)
		throws IOException 
	{
		super(out);
		addManifest(man);
	}
	
	/**
	 * Return a boolean indicating whether the specified
	 * entry has already been added to the output stream.
	 * 
	 * @param ze
	 * @return
	 */
	public boolean alreadyAdded(ZipEntry ze) {
		return addedEntryNames.contains(ze.getName());
	}
	
	/**
	 * @see java.util.zip.ZipOutputStream#putNextEntry(java.util.zip.ZipEntry)
	 */
	public void putNextEntry(ZipEntry ze) throws IOException {
		super.putNextEntry(ze);
		addedEntryNames.add(ze.getName());
	}
	
	/**
	 * Add the manifest to the output stream.
	 * 
	 * @param man
	 * @throws IOException
	 */
	private void addManifest(Manifest man) throws IOException {
		if (man == null) {
		    throw new NullPointerException(Messages.EntryTrackingJarOutputStream_NOManifest);
		}
		
		ZipEntry e = new ZipEntry(JarFile.MANIFEST_NAME);
		putNextEntry(e);
		man.write(new BufferedOutputStream(this));
		closeEntry();
	}
}
