/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dm.preferences;

import java.util.Iterator;

import org.eclipse.mtj.api.devices.ConfigurationItem;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.core.ui.util.DialogController;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformInfoComposite;

public class DevicePlatformInfoController implements DialogController {
	private DevicePlatformInfoComposite composite;
	private DevicePlatform selectedPlatform;
	
	public DevicePlatformInfoController(DevicePlatformInfoComposite composite, DevicePlatform selectedPlatform) {
		this.composite = composite;
		this.selectedPlatform = selectedPlatform;
		setData();
	}
	
	private void setData() {
		this.composite.getNameLabel().setText(this.selectedPlatform.getName());
		this.composite.getVendorLabel().setText(this.selectedPlatform.getVendor());
		this.composite.getVersionLabel().setText(this.selectedPlatform.getVersion());
		this.composite.getLocationLabel().setText(getRootDirectory(this.selectedPlatform));
	}
	
	private String getRootDirectory(DevicePlatform dp) {
		Iterator it = dp.getConfiguration().getItems().iterator();
		while (it.hasNext()) {
			ConfigurationItem item = (ConfigurationItem) it.next();
			if ("directory".equals(item.getName())) { //$NON-NLS-1$
				String d = item.getValue();
				if (d != null) {
					d = d.replace('\\', '/');
					if (d.endsWith("/")) { //$NON-NLS-1$
						d = d.substring(0, d.length() - 1);
					}
					return d;
				}
			}
		}
		
		return ""; //$NON-NLS-1$
	}

	public void handleOK() {
		// TODO
	}

}
