/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dpp.uei;

import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.core.toolkit.DevicePlatformImporter;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;

/** Generic implementation of a UEI specific Device Platform Provider. */
public class GenericUeiDevicePlatformProvider extends AbstractUeiDevicePlatformProvider implements DevicePlatformProvider, ToolkitSupport {
	public GenericUeiDevicePlatformProvider(){
		super();
		setId(UeiPlugin.getDefault().getBundle().getSymbolicName());
		setDescription(Messages.GenericUeiDevicePlatformProvider_PluginDescription);
		setVendor(Messages.GenericUeiDevicePlatformProvider_PluginVendor);
		setVersion(Messages.GenericUeiDevicePlatformProvider_PluginVersion);
		setType(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL);
	}

	public DevicePlatformImporter getDevicePlatformImporter() {
		return new GenericUeiDevicePlatformImporter();
	}
	
	/**
	 * Method returns Plugin name that owns the DevicePlatform data.
	 * 
	 * @return
	 */
	public String getPluginName() {
		return UeiPlugin.getDefault().getBundle().getSymbolicName();
	}	
}
