/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.preverify.internal.result;

import org.eclipse.mtj.api.model.preverifier.IClassErrorInformation;
import org.objectweb.asm.tree.ClassNode;

/**
 * Implementation of the IClassErrorInformation interface
 * wrapped around a class node.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:52:02 $
 * <br>
 * @author Craig Setera
 */
public class ClassNodeErrorInformation implements IClassErrorInformation {
	private ClassNode classNode;
	
	/**
	 * Construct a new information instance around the specified
	 * class node.
	 * 
	 * @param classNode
	 */
	public ClassNodeErrorInformation(ClassNode classNode) 
	{
		super();
		this.classNode = classNode;
	}

	/**
	 * @see eclipseme.preverifier.results.IClassErrorInformation#getName()
	 */
	public String getName() {
		return classNode.name;
	}

	/**
	 * @see eclipseme.preverifier.results.IClassErrorInformation#getSourceFile()
	 */
	public String getSourceFile() {
		return classNode.sourceFile;
	}
}
