/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.page;

import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ExtensionHeader extends Composite {

	Label label_type_l;
	Label label_type;
	Label label_vendor_l;
	Label label_vendor;
	Label label_version_l;
	Label label_version;
	Button swt_checkbox_active;
	Label label_active_l;
	MtjExtension extension;
	
	
	public ExtensionHeader (Composite parent, int style) {
		super (parent, style);
		
		init();
	}

	protected void init() {
		GridLayout layout = new GridLayout();
		this.setLayout(layout);
		layout.numColumns = 3;
		layout.marginHeight = 20;
		layout.marginWidth = 20;
		
		label_type_l = new Label(this, SWT.NONE);
		GridData gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 1;
		label_type_l.setLayoutData(gd);
		label_type_l.setText(" "); //$NON-NLS-1$
		
		label_type = new Label(this, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 2;
		label_type.setLayoutData(gd);
		label_type.setText(" "); //$NON-NLS-1$
		
		label_vendor_l = new Label(this, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 1;
		label_vendor_l.setLayoutData(gd);
		label_vendor_l.setText(" "); //$NON-NLS-1$
		
		label_vendor = new Label(this, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 2;
		label_vendor.setLayoutData(gd);
		label_vendor.setText(" "); //$NON-NLS-1$
		
		label_version_l = new Label(this, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 1;
		label_version_l.setLayoutData(gd);
		label_version_l.setText(" "); //$NON-NLS-1$
		
		label_version = new Label(this, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 2;
		label_version.setLayoutData(gd);
		label_version.setText(" "); //$NON-NLS-1$
		
		Label label = new Label(this, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 1;
		label.setLayoutData(gd);
		label.setText(" "); //$NON-NLS-1$
		
		swt_checkbox_active = new Button(this, SWT.CHECK);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 1;
		swt_checkbox_active.setLayoutData(gd);
		swt_checkbox_active.addSelectionListener(
				new SelectionListener() {
					public void widgetSelected(SelectionEvent e) {
						((ExtensionPropertyPage)getParent()).changedExtensionActivity(swt_checkbox_active.getSelection());
					}
					public void widgetDefaultSelected(SelectionEvent e) {}
				}
		);
		swt_checkbox_active.setVisible(false);
		
		label_active_l = new Label(this, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 1;
		label_active_l.setLayoutData(gd);
		label_active_l.setText(" "); //$NON-NLS-1$
		
	}
	
	public void setMtjExtension(MtjExtension extension) {
		this.extension = extension;
		
		label_type_l.setText(   Messages.ExtensionHeader_TypeLabel);
		label_vendor_l.setText( Messages.ExtensionHeader_VendorLabel);
		label_version_l.setText(Messages.ExtensionHeader_VersionLabel);
		label_active_l.setText(Messages.ExtensionHeader_Active);
		
		label_type.setText(extension.getType() != null ? extension.getType().toString() : ""); //$NON-NLS-1$
		label_vendor.setText(extension.getVendor() != null ? extension.getVendor() : ""); //$NON-NLS-1$
		label_version.setText(extension.getVersion() != null ? extension.getVersion() : ""); //$NON-NLS-1$
		swt_checkbox_active.setSelection(extension.isActive());
		swt_checkbox_active.setVisible(true);
		
		label_type.pack();
		label_vendor.pack();
		label_version.pack();
		swt_checkbox_active.pack();
		label_type_l.pack();
		label_vendor_l.pack();
		label_version_l.pack();
		label_active_l.pack();
		
		pack();
	}
}
