/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.preferences.control.ManagerPrefPage;
import org.eclipse.mtj.core.ui.preferences.control.ProviderPrefPage;
import org.eclipse.mtj.core.ui.util.CorePluginImages;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class MTJCorePreferencePage extends PreferencePage
	implements IWorkbenchPreferencePage {
	private ManagerPrefPage _mngrPage;
	private ProviderPrefPage _provPage;
	private Composite controll;	
	
	public MTJCorePreferencePage() {
		super();
		setPreferenceStore(MtjCoreUiPlugin.getDefault().getCorePreferenceStore());
		setDescription(Messages.MTJCorePreferencePage_PreferencePageImplementation);
	}
		
	private Control buildControl(Composite parent) {
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
				parent,	MtjCoreUiPlugin.getPluginId()+".mtjcore0000"); //$NON-NLS-1$
	
		Composite composite = new Composite(parent, SWT.NONE);

		GridData data = GridUtil.createFill();
		data.heightHint = 100;
		composite.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
	
		TabFolder folder = new TabFolder(composite, SWT.NONE);
		data = GridUtil.createFill();
		data.heightHint = 350;
		folder.setLayoutData(data);

		TabItem item;

		/*
		  
		item = new TabItem(folder, SWT.NONE);
		item.setText("General");
		item.setImage(CorePluginImages.getImage(CorePluginImages.IMG_CORE_LOGO));
		//_core = new CorePrefPage(getPreferenceStore());
		_core = new MtjProjectPreferencePage();
		_core.createControl(folder);
		item.setControl( _core.getControl() );
		*/
	
		item = new TabItem(folder, SWT.NONE);
		item.setText(Messages.MTJCorePreferencePage_Frameworks);
		item.setImage(CorePluginImages.getImage(CorePluginImages.IMG_MANAGER));
		_mngrPage = new ManagerPrefPage(getPreferenceStore());
		item.setControl(_mngrPage.createContents(folder));
	
		item = new TabItem(folder, SWT.NONE);
		item.setText(Messages.MTJCorePreferencePage_Providers); 
		item.setImage(CorePluginImages.getImage(CorePluginImages.IMG_PROVIDER));
		_provPage = new ProviderPrefPage(getPreferenceStore());
		item.setControl(_provPage.createContents(folder));
	
		//noDefaultAndApplyButton();
		
		return composite;		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent) {
		class LoadData  implements IRunnableWithProgress {
			private MTJCorePreferencePage page;
			private Composite parent;
			
			public LoadData(MTJCorePreferencePage page, Composite parent) {
				this.page = page;
				this.parent = parent;
			}
						
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				monitor.beginTask(Messages.MTJCorePreferencePage_LoadingMtjPreferenceData, 100);
				monitor.worked(50);
				page.buildControl(parent);				
				monitor.done();
			}
		}

		try {
			IRunnableWithProgress op = new LoadData(this, parent);
			new ProgressMonitorDialog(parent.getShell()).run(false, false, op);
		} catch (Exception e) {
			e.printStackTrace();
			// TODO
		}

		return controll;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
	 */
	protected void performDefaults() {
		super.performDefaults();
		//_core.performDefaults();
		_mngrPage.performDefaults();
		_provPage.performDefaults();
		
		resetMessageOnStatusLine();
		setValid(true);
	}
	/**
	 * Perform neccessary validation/preference save when the OK button is pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {		
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, Messages.MTJCorePreferencePage_PerformOK));
		boolean returnValue = _mngrPage.performOk() && _provPage.performOk();
		return returnValue;
	}
	
	
	/**
	 * @see org.eclipse.jface.preference.PreferencePage#performApply()
	 */
	protected void performApply() {
		
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, Messages.MTJCorePreferencePage_CorePerformOK));
		
		_mngrPage.performApply();
		_provPage.performApply();
	}
	
	/**
	 * show message on Status Line of CorePrefPage
	 */
	protected void showMessageOnStatusLine(){
		StatusUtil.applyToStatusLine(this,new StatusInfo(IStatus.ERROR, "!")); //$NON-NLS-1$
	}
	/**
	 * reset message on Status Line of LogAnalyzerBasePrefPage
	 */
	protected void resetMessageOnStatusLine(){
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, ""));  //$NON-NLS-1$
	}

	
}