/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionContentProvider;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionImplNode;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionLabelProvider;
import org.eclipse.mtj.core.ui.preferences.view.MTJProviderViewUI;
import org.eclipse.mtj.core.ui.preferences.view.ProjectScopeDialog;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ProviderPrefPage extends PreferencePage implements MouseListener, SelectionListener {
	public static final String PREF_ID= "org.eclipse.mtj.extension.rpm.ui.preferences.ProjectRuntimeMgmtPreferencePage"; //$NON-NLS-1$
	//"org.eclipse.mtj.core.ui.preferences.control.MtjProjectPreferencePage"; //$NON-NLS-1$
	public static final String PROP_ID= "org.eclipse.mtj.extension.rpm.ui.preferences.ProjectRuntimeMgmtPreferencePage";  //$NON-NLS-1$
	//"org.eclipse.mtj.core.ui.properties.control.MtjProjectPreferencePage"; //$NON-NLS-1$
	
	public static final String PLUGIN_ID = "org.eclipse.mtj.extension.devide"; //$NON-NLS-1$
	public static final String MTJ_NATURE_ID = PLUGIN_ID + ".nature"; //$NON-NLS-1$
	protected static String srvProvFilter = "PROVIDER"; //$NON-NLS-1$
	private MTJProviderViewUI mtjProviderViewUI;
	//                                          Name     Vendor    Version
	private final static String[] COLUMNS = { "STRING", "STRING", "STRING" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	private int rowIndex = 0;
	private ArrayList listeners = new ArrayList(2);
	private IProject fProject; // project or null
	private IJavaProject[] selectedProjects = null;
	public static final String DATA_NO_LINK= "PropertyAndPreferencePage.nolink"; //$NON-NLS-1$	
	private Composite composite = null;

	public ProviderPrefPage(IPreferenceStore preferenceStore) {
		super();
	}

	public ProviderPrefPage(String title) {
		super(title);
	}

	public ProviderPrefPage(String title, ImageDescriptor image) {
		super(title, image);
	}

	public Control createContents(Composite parent) {		
		composite = new Composite(parent, SWT.NONE);
		
        Link lnkProjectSettings = new Link(composite, SWT.NONE);
        GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
        lnkProjectSettings.setLayoutData(gd);
        lnkProjectSettings.setText(Messages.ProviderPrefPage_ConfigureMtjProjectSpecificSettingsText);
        lnkProjectSettings.setToolTipText(Messages.ProviderPrefPage_ConfigureMTJProjectSpecificSettings);

        lnkProjectSettings.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
				doLinkActivated((Link) e.widget);
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				doLinkActivated((Link) e.widget);
			}
        });

        GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
		GridData data = GridUtil.createFill();
		composite.setLayoutData(data);

		mtjProviderViewUI = new MTJProviderViewUI(COLUMNS);
		mtjProviderViewUI.createControl(composite);

		createControl(composite);

		initializeDefaults();
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(composite, MtjCoreUiPlugin.getPluginId()+".mtjcore0003"); //$NON-NLS-1$

		return composite;
	}
	
	private void addListener() {
		mtjProviderViewUI.get_tableList().addSelectionListener(this);
		mtjProviderViewUI.get_tableList().addMouseListener(this);
		mtjProviderViewUI.get_tableList().addSelectionListener(this);
		//mtjProviderViewUI.get_moveUp().addSelectionListener(this);
		//mtjProviderViewUI.get_moveDown().addSelectionListener(this);
		//mtjProviderViewUI.get_selAll().addSelectionListener(this);
		//mtjProviderViewUI.get_unselAll().addSelectionListener(this);
		//mtjProviderViewUI.get_showDetail().addSelectionListener(this);
		//tableViewer.getTable().addSelectionListener(this);
	}
	
	public void createControl(Composite parent) {
		mtjProviderViewUI.getTableViewer().setContentProvider(new ExtensionContentProvider());
		mtjProviderViewUI.getTableViewer().setLabelProvider(new ExtensionLabelProvider());

		addListener();
		
		TableViewerSorter.setTableSorter(mtjProviderViewUI.getTableViewer(), 0, true);
		mtjProviderViewUI.getTableViewer().getTable().addListener(SWT.Selection, new Listener() {
		      public void handleEvent(Event event) {
		        TableItem tableItem = (TableItem)event.item;
		        ExtensionImplNode node = (ExtensionImplNode)tableItem.getData();
		        MtjExtension mtjExtension = null;
		        
		        rowIndex = mtjProviderViewUI.getTableViewer().getTable().getSelectionIndex();
		        
		        if (tableItem.getChecked()) {		        	
		        	if (node.getImpl() instanceof MtjExtension){
			        	mtjExtension = (MtjExtension)node.getImpl();
			        	mtjExtension.setActive(true);
			        	node.setActive(Boolean.TRUE.toString());
		        	}	
		        }		        	
		        else{
		        	if (node.getImpl() instanceof MtjExtension){
			        	mtjExtension = (MtjExtension)node.getImpl();
			        	mtjExtension.setActive(false);
			        	node.setActive(Boolean.FALSE.toString());
		        	}	
		        }
		        
		        /*try {
					mtjProviderViewUI.get_showDetail().setEnabled(MtjServices.getInstance().getCorrespondingAdminGuiProvider(mtjExtension).getPreferencePage() != null);
				} catch (MtjException e) {
					e.printStackTrace();
				}*/
		        mtjProviderViewUI.getTableViewer().getTable().redraw();
		      }
		    }
		);
		mtjProviderViewUI.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				Object o = ((IStructuredSelection)mtjProviderViewUI.getTableViewer().getSelection()).getFirstElement();
				int size = mtjProviderViewUI.getTableViewer().getTable().getItemCount();
				/*if( o == mtjProviderViewUI.getTableViewer().getElementAt(0)) {
					mtjProviderViewUI.get_moveUp().setEnabled(false);
					mtjProviderViewUI.get_moveDown().setEnabled(true);
				} else if( o == mtjProviderViewUI.getTableViewer().getElementAt(size-1)) {
					mtjProviderViewUI.get_moveDown().setEnabled(false);
					mtjProviderViewUI.get_moveUp().setEnabled(true);
				} else {
					mtjProviderViewUI.get_moveDown().setEnabled(true);
					mtjProviderViewUI.get_moveUp().setEnabled(true);
				}*/				
			} 
			} 
		);

		mtjProviderViewUI.getTableViewer().setInput(parent);
		mtjProviderViewUI.getTableViewer().refresh();
	}

	public void mouseDoubleClick(MouseEvent e) {}
	public void mouseDown(MouseEvent e) {}
	public void mouseUp(MouseEvent e) {}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);		
	}

	public void widgetSelected(SelectionEvent e) {
		notifyListeners(e);

		// MoveUp -button clicked		
		/*if (e.widget == mtjProviderViewUI.get_moveUp()) {
			
			int idx = mtjProviderViewUI.get_tableList().getSelectionIndex();
			if (idx > 0)
				rowIndex = idx;
			
			moveUp(idx, mtjProviderViewUI.get_tableList());
		// MoveDown -button clicked
		} else if (e.widget == mtjProviderViewUI.get_moveDown()) {
			int idx = mtjProviderViewUI.get_tableList().getSelectionIndex();

			if (idx != -1 && (idx < mtjProviderViewUI.get_tableList().getItemCount() - 1))
				rowIndex = idx;
				moveDown(idx, mtjProviderViewUI.get_tableList());

		// SelectAll -button clicked
		} else if (e.widget == mtjProviderViewUI.get_selAll()) {
			for (int idx = 0; idx < mtjProviderViewUI.get_tableList().getItemCount(); idx++) {
				TableItem item = mtjProviderViewUI.get_tableList().getItem(idx);
				item.setChecked(true);

				ExtensionImplNode _cd = (ExtensionImplNode)item.getData();
		        
				MtjExtension _m = null;
		        if (_cd.getImpl() instanceof MtjExtension){
			       	_m = (MtjExtension)_cd.getImpl();
			       	_m.setActive(true);
			       	item.setChecked(true);
		        }
			
			}
			return;
			
		// UnSelectAll -button clicked
		} else if (e.widget == mtjProviderViewUI.get_unselAll()) {
			for (int idx = 0; idx < mtjProviderViewUI.get_tableList().getItemCount(); idx++) {
				TableItem item = mtjProviderViewUI.get_tableList().getItem(idx);
				item.setChecked(false);

				ExtensionImplNode _cd = (ExtensionImplNode)item.getData();
		        MtjExtension _m = null;
		        if (_cd.getImpl() instanceof MtjExtension){
			       	_m = (MtjExtension)_cd.getImpl();
			       	_m.setActive(false);
		        }
   	
			}					
			return;
			
		// ShowDetail -button clicked
		} else if (e.widget == mtjProviderViewUI.get_showDetail()) {
			ExtensionImplNode columnData = (ExtensionImplNode) mtjProviderViewUI.get_tableList().getItem(rowIndex).getData();
			if (columnData.getImpl() instanceof MtjExtension){
				showDetailDialog((MtjExtension)columnData.getImpl());
			}
		}*/

		int idx = mtjProviderViewUI.get_tableList().getSelectionIndex();
		ExtensionImplNode data = null;
		ExtensionImplNode previousData = null;
		if (idx > 0) {
			rowIndex = idx;
			previousData = (ExtensionImplNode) mtjProviderViewUI.get_tableList().getItem(idx - 1).getData();
		}
		if (idx != -1) {
			rowIndex = idx;
			data = (ExtensionImplNode) mtjProviderViewUI.get_tableList().getItem(idx).getData();
		}
		
		//mtjProviderViewUI.get_moveUp().setEnabled(data != null && previousData != null);
		//mtjProviderViewUI.get_moveDown().setEnabled(data != null && (idx < mtjProviderViewUI.get_tableList().getItemCount() - 1));		
	}
	
	private static void showDetailDialog(MtjExtension mtjExtension) {
		class InfoDialog extends TitleAreaDialog {
			private PreferencePage page;
			private MtjExtension extension;
			
			public InfoDialog(PreferencePage page, MtjExtension extension) {
				super(MtjCorePlugin.getDefault().getActiveShell());
				this.setShellStyle(getShellStyle() | SWT.MAX | SWT.RESIZE);
				this.page = page;
				this.extension = extension;
			}
			
			protected Control createDialogArea(Composite parent) {
				this.setTitle(Messages.ProviderPrefPage_ProviderInfo);
				this.setMessage(extension.getId());
				
				if(page != null) {
					page.createControl(parent);
				}
				return parent;
			}
		};
		
		PreferencePage page = null;
		try {
			page = MtjServices.getInstance().getCorrespondingAdminGuiProvider(mtjExtension).getPreferencePage();
		} catch (MtjException e) {
			e.printStackTrace();
		}
		TitleAreaDialog dialog = new InfoDialog(page, mtjExtension);	
       	dialog.open();
	}
	
	public void addListener(SelectionListener listener){
		if(!listeners.contains(listener)){
			listeners.add(listener);		
		}
	}
	
	public void removeListener(SelectionListener listener){
		listeners.remove(listener);
	}
	
	final void doLinkActivated(Link link) {
		Map data= new HashMap();
		data.put(DATA_NO_LINK, Boolean.TRUE);
		IJavaProject[] projects = null;
		
		if (isProjectPreferencePage()) {
			openWorkspacePreferences(data);
		} else {
			HashSet projectsWithSpecifics= new HashSet();
			try {
				projects = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
				for (int i= 0; i < projects.length; i++) {
					IJavaProject curr= projects[i];
					if (hasProjectSpecificOptions(curr.getProject())) {
						projectsWithSpecifics.add(curr);
					}
				}
			} catch (JavaModelException e) {
				// ignore
			} catch ( CoreException ex) {
				MtjCoreUiPlugin.displayError(MtjCorePlugin.getDefault().getActiveShell(),1,1,Messages.ProviderPrefPage_Error,Messages.ProviderPrefPage_ErrorOccured, ex);						
			}

			ProjectScopeDialog _dialog = new ProjectScopeDialog(MtjCorePlugin.getDefault().getActiveShell(), Messages.ProviderPrefPage_SelectMTJProjects, projectsWithSpecifics, projects);

			if (_dialog.open() == Window.OK) {
				IJavaProject[] _selectedProjects = _dialog.getSelectionResult();
				setSelectedProjects(null);				
				//Save selected projects to later usage
				setSelectedProjects(_selectedProjects);
				for (int i= 0; i < _selectedProjects.length; i++) {
					//System.out.println( ((IProject)_selectedProjects[i].getProject()).getName());
					IJavaProject res = _selectedProjects[i];
					//openProjectProperties( res.getProject(), data );
				}
			}
		}
	}
	protected boolean isProjectPreferencePage() {
		return fProject != null;
	}
	
	protected final void openWorkspacePreferences(Object data) {
		String id= getPreferencePageID();
		PreferencesUtil.createPreferenceDialogOn(getShell(), id, new String[] { id }, data).open();
	}
	protected final void openProjectProperties(IProject project, Object data) {
		String id= getPropertyPageID();
		if (id != null) {
			PreferencesUtil.createPropertyDialogOn(getShell(), project, id, new String[] { id }, data).open();
		}
	}		
	
	/** 
	 * getSelectedProjects -method
	 * @return selected MTJ projects
	 */
	private IJavaProject[] getSelectedProjects() {
		if (selectedProjects.length >0 ){
			return selectedProjects;
		} else {
			return null;
		}	
	}	
	
	/**
	 * setSelectedProjects -method
	 * Sets the selected MTJ projects to internal variable 
	 * @param _prj
	 */
	protected void setSelectedProjects(IJavaProject[] _prj){
		selectedProjects = _prj;
	}		
	
	private String getPreferencePageID() {
		return PREF_ID;
	}

	protected String getPropertyPageID() {
		return PROP_ID;
	}
	
	/* 
	 * hasProjectSpecificOptions -method
	 * Checks that are there any MTJ nature id's in the project
	 *
	 * @param project IProject
	 * @return boolean indicating the success
	 * @throws CoreException
	 */
	protected boolean hasProjectSpecificOptions(IProject project) throws CoreException {
		IProjectDescription description = project.getDescription();
		String[] natures = description.getNatureIds();
		for (int i = 0; i < natures.length; ++i) {
			if (getNatureID().equals(natures[i])) {
				// MTJ Nature found
				return true;
			}
		}
		//No MTJ nature found
		return false;
	}

	/**
	 * Return a boolean indicating whether the specified project has the J2ME
	 * nature associated with it.
	 * 
	 * @param project the project to be tested for the J2ME nature
	 * @return a boolean indicating whether the specified project has
	 * the J2ME nature
	 * @throws CoreException
	 */
	public static boolean hasMtjNature(IProject project) throws CoreException {
		return project.hasNature(MTJ_NATURE_ID);
	}
	
	public static String getNatureID ()	{
		return MTJ_NATURE_ID;
	}
	
	/**
	 * storeValues -method
	 * Stores the changes preference values to the preferences
	 */
	public void storeValues() {
		boolean _hasProjectScope = false;
		 
		if ( selectedProjects != null && selectedProjects.length >0)
			_hasProjectScope = true;
		
		TableItem[] items = mtjProviderViewUI.getTableViewer().getTable().getItems();
    	for (int i = 0; i < items.length; i++) {
			ExtensionImplNode _cd = (ExtensionImplNode)items[i].getData();
    		if ( _cd.getImpl() != null && _cd.getImpl() instanceof MtjExtension ) {
    			MtjExtension mtjE = (MtjExtension)_cd.getImpl();
    			try {
    				// We loop through the selected projects and set MtjService activity based on that
    				if (_hasProjectScope ){    					
    					for (int ix = 0; ix < selectedProjects.length; ix++ ){
    						IProject _prj = (IProject) ((IJavaProject)selectedProjects[ix]).getProject();
    						MtjServices.getInstance().setActive(mtjE.getId(), mtjE.getType(),_prj.getName(), items[i].getChecked());
    					}	
    				} else {
    					MtjServices.getInstance().setActive(mtjE.getId(), mtjE.getType(),items[i].getChecked());
    				}	
    			} catch ( MtjException mtjEx ) {
    				MtjCoreUiPlugin.displayError(MtjCorePlugin.getDefault().getActiveShell(),1,1,Messages.ProviderPrefPage_Error,Messages.ProviderPrefPage_ErrorOccurred, mtjEx);
    				
    			}
    		}
    	}
	}
	
	/**
	 * notifyListeners -method
	 * Notifies listeners
	 * @param e
	 */
	public void notifyListeners(SelectionEvent e) {
		for(int i=0;i<listeners.size();i++){
			((SelectionListener)listeners.get(i)).widgetSelected(e);
		}
	}
	
	/**
	 * getSelectedRow_Index -method 
	 * @return Table active selected row index
	 */
	public int getSelectedRow_Index() {
		return rowIndex;
	}
	
	/**
	 * moveDown -method
	 * @param idx
	 * @param _list
	 */
	protected void moveDown(int idx, Table _list) {
		mtjProviderViewUI.getTableViewer().getTable().deselect(idx);
		mtjProviderViewUI.getTableViewer().getTable().select(idx + 1);
		rowIndex = idx + 1;
	}
	
	/**
	 * moveUp -method
	 * @param idx
	 * @param _list
	 */
	protected void moveUp(int idx, Table _list) {
		mtjProviderViewUI.getTableViewer().getTable().deselect(idx);
		mtjProviderViewUI.getTableViewer().getTable().select(idx - 1);
		rowIndex = idx -1;		
	}

	/**
	 * getMtjProviderViewUI -method
	 * @return Returns the mtjProviderViewUI.
	 */
	public MTJProviderViewUI getMtjProviderViewUI() {
		return mtjProviderViewUI;
	}
	
	/**
	 * initializeDefaults -method
	 */
	private void initializeDefaults() {
		initializeValues(true);
	}
	
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues(boolean _startUp) {
		if (_startUp){
			mtjProviderViewUI.getTableViewer().addFilter(new ViewerFilter() {
				public boolean select(Viewer viewer, Object parentElement, Object element) {
					ExtensionImplNode _cd = (ExtensionImplNode)element;
					return ( _cd.getName().toUpperCase().endsWith(srvProvFilter) ) ;
				}
			});
		}
		if (mtjProviderViewUI.getTableViewer().getTable().getItemCount() > 0) {
			mtjProviderViewUI.getTableViewer().getTable().select(0);
			//mtjProviderViewUI.get_moveDown().setEnabled(true);
		}
 		for (int idx = 0; idx < mtjProviderViewUI.getTableViewer().getTable().getItemCount(); idx++) {		
			try {
				TableItem _item = mtjProviderViewUI.getTableViewer().getTable().getItem(idx);
				ExtensionImplNode _cd = (ExtensionImplNode)_item.getData();
				MtjExtension _m = null;
				if (_cd.getImpl() instanceof MtjExtension){
					_m = (MtjExtension)_cd.getImpl();
					_item.setChecked(_m.isActive());
				}
			} catch (Exception ex) {
				MtjCoreUiPlugin.displayError(MtjCorePlugin.getDefault().getActiveShell(),1,1,Messages.ProviderPrefPage_Error,Messages.ProviderPrefPage_ErrorOccurred, ex);			
			}
		}	
	}
	
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	public void performDefaults() {
		initializeDefaults();
	}

	public void performApply() {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.INFO, Messages.ProviderPrefPage_ProviderPerformApply));
		storeValues();
		super.performApply();
	}

	public boolean performCancel() {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.CANCEL, Messages.ProviderPrefPage_ProviderPerformCancel));
		return super.performCancel();
	}

	public void performHelp() {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.INFO, Messages.ProviderPrefPage_ProviderPerformHelp));
		super.performHelp();
	}

	public boolean performOk() {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, Messages.ProviderPrefPage_ProviderPerformOK));
		storeValues();
		return super.performOk();
	}
}
