/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.util;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.api.devices.ConfigurationError;
import org.eclipse.mtj.api.devices.ConfigurationItem;


public class DeviceConfigurationSorter extends ViewerSorter {

	public int compare(Viewer viewer, Object o1, Object o2) {
		
		String s1 = ""; //$NON-NLS-1$
		String s2 = ""; //$NON-NLS-1$

		if(o1 instanceof ConfigurationItem){
			s1 = ((ConfigurationItem)o1).getLabel();
		}
		else if(o1 instanceof ConfigurationError){
			s1 = ((ConfigurationError)o1).getErrorType();
		}
		if(o2 instanceof ConfigurationItem){
			s2 = ((ConfigurationItem)o2).getLabel();
		}
		else if(o2 instanceof ConfigurationError){
			s2 = ((ConfigurationError)o2).getErrorType();
		}

		return compare(s1, s2);
	}
	
	protected int compare(String task1, String task2) {
		int result = collator.compare(task1, task2);
		//if (reversed)
		//	result = -result;
		return result;
	}
}
