/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dm.ui.util;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;


public class DevicePlatformImportContentProvider implements
		ITreeContentProvider {

	private DevicePlatform[] myContents;
	private Viewer myViewer;
	
	private Hashtable dpAndDevices;
	
	public DevicePlatformImportContentProvider(Viewer viewer) {
		super();
		
		myViewer = viewer;
		dpAndDevices = new Hashtable();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		
		
		List l = new Vector();
		
		if(parentElement instanceof DevicePlatform){
			DevicePlatform dp = (DevicePlatform)parentElement;
			l.addAll(dp.getDevices());
			//l.addAll(dp.getRuntimePlatformDefinitions());
			return l.toArray();
		}
//		else if(parentElement instanceof RuntimePlatformDefinition){
//			RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)parentElement;
//			l.addAll(rpd.getDeviceConfigurations());
//			l.addAll(rpd.getDeviceProfiles());
//			l.addAll(rpd.getServiceApis());
//			return l.toArray();
//		}
//		else if(parentElement instanceof Device){
//			Device device = (Device)parentElement;
//			l.add(PreferenceUtils.getObjectStyledName(parentElement));
//			return l.toArray();
			
//			EList rpds = device.getRuntimePlatformDefinitions();
//			if(rpds != null){
//				l.addAll(device.getRuntimePlatformDefinitions());
//				return l.toArray();
//			}
//			return null;
//		}
//		else if(parentElement instanceof DeviceConfiguration){
//			DeviceConfiguration config = (DeviceConfiguration)parentElement;
//			l.add(PreferenceUtils.getObjectName(parentElement));
//			//l.add(config.getImplementation());
//			return l.toArray();
//		}
//		else if(parentElement instanceof DeviceProfile){
//			DeviceProfile profile = (DeviceProfile) parentElement;
//			//l.addAll(profile.getServiceApis());
//			l.add(PreferenceUtils.getObjectName(parentElement));
//			return l.toArray();
//		}
//		else if(parentElement instanceof ServiceApi){
//			ServiceApi sapi = (ServiceApi) parentElement;
//			l.add(PreferenceUtils.getObjectName(parentElement));
//			//l.add(sapi.getDescription());
//			//l.add(sapi.getImplementation());
//			return l.toArray();
//		}
//		else if(parentElement instanceof ImplementationRef){
//			ImplementationRef ref = (ImplementationRef)parentElement;
//			//l.add(ref.getFileRef()); //already in parent
//			l.add(ref.getSourceRef());
//			l.add(ref.getJavadocRef());
//			return l.toArray();
//		}
		else
			return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {

		if(element instanceof Device){
			return dpAndDevices.get(element);
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {

		if(element instanceof DevicePlatform){
			return true;
		}
		
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {

		return myContents;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		
		myViewer = viewer;
		
		if(newInput instanceof DevicePlatform[]){
			DevicePlatform[] inputArray = (DevicePlatform[]) newInput;
			myContents = new DevicePlatform[inputArray.length];
			System.arraycopy(inputArray, 0, myContents, 0, inputArray.length);
//			myContents = new DevicePlatform[];
//			myContents = (DevicePlatform[]) newInput;
			updateDpAndDevices();
		}
		else if(newInput instanceof EList){
			
			myContents = (DevicePlatform[])((EList)newInput).toArray();
			updateDpAndDevices();
		}
		else if(newInput == null){
			myContents = null;
			dpAndDevices.clear();
		}
	}
	
	private void updateDpAndDevices(){
		
		dpAndDevices.clear();

		EList devices = null;
		
		for(int i = 0; i < myContents.length; i++){
			
			 devices = myContents[i].getDevices();
			 
			 for(int j = 0; j < devices.size(); j++){
				 dpAndDevices.put(devices.get(j), myContents[i]);
			 }
		}
	}
}
