/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.devide.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/**
 * An initializer to fill in a J2MEClasspathContainer.
 * <p>
 * <b>Note:</b> This class/interface is part of an interim API that is still under development and expected to
 * change before reaching stability. It is being made available at this early stage to solicit feedback
 * from pioneering adopters on the understanding that any code that uses this API will almost 
 * certainly be broken as the API evolves.
 * </p>
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:51:15 $
 * <br>
 * @author Yang Liu
 * @author Craig Setera
 * 
 * @see eclipseme.core.internal.J2MEClasspathContainer
 */
public class J2MEClasspathContainerInitializer extends ClasspathContainerInitializer 
{
	/**
	 *  Construct a new classpath container intializer for J2ME libraries.
	 */
	public J2MEClasspathContainerInitializer() {
		super();
	}

	/**
	 * @see org.eclipse.jdt.core.ClasspathContainerInitializer#initialize(org.eclipse.core.runtime.IPath, org.eclipse.jdt.core.IJavaProject)
	 */
	public void initialize(IPath containerPath, IJavaProject project)
			throws CoreException 
	{
		int size = containerPath.segmentCount();

		if (size > 0) {
			if (containerPath.segment(0).equals(J2MEClasspathContainer.J2ME_CONTAINER)) {
				IJavaProject[] projects = new IJavaProject[] { project }; 
				IClasspathContainer[] containers = 
					new IClasspathContainer[] { new J2MEClasspathContainer(project, containerPath) };
				JavaCore.setClasspathContainer(containerPath, projects, containers, null);
			}
		}
	}
}
