/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.devide.properties;

import java.util.logging.Logger;

import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class MtjProjectPage extends PropertyPage implements IWorkbenchPropertyPage{
	private static Logger log = Logger.getLogger(MtjProjectPage.class.getName());
		
	public MtjProjectPage() {
		super();
		log.info(Messages.MtjProjectPage_Constructing_project_propert_page);
		setTitle(Messages.MtjProjectPage_MTJ_Project_Title);
		// setDescription("Select and edit Project's Runtime Platform");
		noDefaultAndApplyButton();
	}
		
	protected Control createContents(Composite parent) {
		return build(parent);
	}
		
	private static void createText(Composite parent, String title, String text) {
		Group deployGroup = new Group(parent,SWT.NONE);
		deployGroup.setText(title);
		deployGroup.setLayout(new FillLayout());
		ScrolledComposite scroll = new ScrolledComposite(deployGroup, SWT.H_SCROLL | SWT.V_SCROLL);
		Composite composite = new Composite(scroll, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		composite.setLayout(layout);
		
		Text deployText = new Text(composite, SWT.MULTI); 
		deployText.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
		deployText.setEditable(false);
		deployText.setText(text);
		composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		scroll.setContent(composite);
	}
	
	private static Control build(Composite parent) {
		parent.setLayout(new FillLayout(SWT.VERTICAL));
		/*
		createText(parent, "Deploy", "Page provides options:\n" + //$NON-NLS-1$ //$NON-NLS-2$
				"\n" + //$NON-NLS-1$
				"- Select project's deployment provider\n" + //$NON-NLS-1$
				"- Select target devices to deploy application"); //$NON-NLS-1$
		*/		
		createText(parent, "Runtime Plaform", "Page provides options to:\n" + //$NON-NLS-1$ //$NON-NLS-2$
				"\n" + //$NON-NLS-1$
				"- Select projects target RuntimePlatform\n" + //$NON-NLS-1$
				"- Edit RuntimePlatform's values"); //$NON-NLS-1$
			
		return null;
	}
	
	public void init(IWorkbench workbench) {
	}

	public boolean performOk() {
		return true;
	}
}
