/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.devide.properties;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class RuntimePlatformPage extends PropertyPage implements IWorkbenchPropertyPage{
	private static Logger log = Logger.getLogger(RuntimePlatformPage.class.getName());
	
	private IMtjProject myProject;
	private Project myProjectData;
	
	private RuntimeListController controller;

	public RuntimePlatformPage() {
		super();
		log.info(Messages.RuntimePlatformPage_Constructing_devide_property_page);
		setTitle(Messages.RuntimePlatformPage_Project_Runtime_Platform_title);
		setDescription(Messages.RuntimePlatformPage_Select_and_edit_runtime_platform);
		noDefaultAndApplyButton();
	}
	
	protected Control createContents(Composite parent) {
		initData();
		RuntimeListComposite rlc = new RuntimeListComposite(parent);
		controller = new RuntimeListController(rlc, myProject, myProjectData);
		return rlc;
	}
	
	private void initData() {
		IJavaProject javaProject = ((IJavaProject)getElement()).getJavaProject();
		
		try {
			myProject = MtjProject.getMtjProject(javaProject);
			myProjectData = myProject.getProjectData();
		} catch (Exception e) {
			log.log(Level.WARNING,Messages.RuntimePlatformPage_Can_not_find_project,e);
		}
	}
	
	public void init(IWorkbench workbench) {
	}

	public boolean performOk() {
		try {
			this.myProjectData.setDefaultTargetDevice(controller.getDefaultTargetDevice());
			this.myProject.setProjectData(this.myProjectData);
		} catch (Exception e) {
			log.log(Level.WARNING,Messages.RuntimePlatformPage_Can_not_save_project_data,e);
			return false;
		}
		return true;
	}
}

