/*******************************************************************************
* Copyright (c) 1998, 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;


import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.core.ui.model.ProjectCreationModel;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.core.J2MEClasspathContainer;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.devide.ui.wizard.midletsuite.MidletSuitePackagingWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class MTJNewProjectWizardPage extends NewJavaProjectWizardPage {

	static char sep = Path.SEPARATOR;
	public ProjectCreationModel projectModel;
	MTJNewProjectSelectLibraryWizardPage javaSDKPage;
	MidletSuitePackagingWizardPage midletPage;
	TargetDevice lastTargetDevice = null;
	boolean forMIDP = false;
	String binDirectoryName = null;
	String srcDirectoryName = null;
	
	// We need to know if we stored temporary data so that we delete it later
	private boolean savedTemporaryMetadata = false;
	
	/**
	 * Constructor for MTJNewProjectWizardPage.
	 * @param root
	 * @param mainpage
	 */
	public MTJNewProjectWizardPage(
		IWorkspaceRoot root,
		WizardNewProjectCreationPage mainpage, 
		ProjectCreationModel projectModel,
		MTJNewProjectSelectLibraryWizardPage javaSDKPage,
		MidletSuitePackagingWizardPage midletPage) 
	{
		super(root, mainpage);
		this.projectModel = projectModel;
		this.javaSDKPage = javaSDKPage;
		this.midletPage = midletPage;
		setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);

	}
	
	public void setForMidp (boolean value)
	{
		forMIDP = value;
	}
	public void setForMidp ()
	{
		forMIDP = true;
	}
	
	/**
	 * Make sure that the classpath refelcts the latest changes
	 */
	@Override
	public Control getControl() {
		setProjectModified();  // This will call initBuildPathsae
		return super.getControl();
	}
	
	/**
	 * @see NewJavaProjectWizardPage#initBuildPaths()
	 * 
	 * This method is overriden to use an output folder other than the
	 * project root, regardless the preference
	 * @see PreferenceConstants
	 */
	protected void initBuildPaths() {
		
		if (!updateDefaultClassPath())
			return;

		/*
		 * set inititial build output folder
		 */
		
		boolean useSrcAndOutputDir = PreferenceConstants.getPreferenceStore().getBoolean(PreferenceConstants.SRCBIN_FOLDERS_IN_NEWPROJ);
		if (useSrcAndOutputDir)
		{
			String srcbinBINName = PreferenceConstants.getPreferenceStore().getString(PreferenceConstants.SRCBIN_BINNAME);
			IPath path = new Path(sep + getProjectHandle().getName() + sep + srcbinBINName);
			setDefaultOutputFolder(path);
		}
		else
		{
			String srcbinBINName = "bin"; //$NON-NLS-1$
			IPath path = new Path(sep + getProjectHandle().getName() + sep + srcbinBINName);
			setDefaultOutputFolder(path);
		}
		/*
		 * call super to ensure all existing paths (such as a library container) 
		 * have been added to the path
		 */
		super.initBuildPaths();
	} 
	
	private boolean updateDefaultClassPath()
	{
		TargetDevice[] targetDevice = javaSDKPage.getProjectModelData();
		if (targetDevice == null || targetDevice.length == 0 || targetDevice[0].getRuntimePlatform() == null)
			return false;
//		if (targetDevice. == lastTargetDevice)
//			return false;
		lastTargetDevice = targetDevice[0];
//		//Now doing this conversion in the classpath file instead of here.
//		RuntimePlatformDefinition platformDefinition = targetDevice.getRuntimePlatform();
//		IClasspathEntry[] cpEntries = J2MEClasspathContainer.getClasspathEntries(platformDefinition);
//		//This is the area where the data is going to be stored
//		IPath metaDataArea = MtjDevIdePlugin.getDefault().getStateLocation();
		
		

		IPath entryPath =
			new Path(J2MEClasspathContainer.J2ME_CONTAINER);
		
		List classpathEntries= new ArrayList();
		classpathEntries.add(getSrcEntry());
		classpathEntries.add(JavaCore.newContainerEntry(entryPath));
		IClasspathEntry[] newEntry= (IClasspathEntry[]) classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]);

		if (forMIDP)
			storeProjectData(ProjectType.PROJECT_TYPE_MIDP_LITERAL, targetDevice);
		else
			storeProjectData(ProjectType.PROJECT_TYPE_PERSONAL_PROFILE_LITERAL, targetDevice);			
		setProjectModified();
		
		// Set the default classpath to the container instead of the JRE libraries.
		super.setDefaultClassPath(newEntry, false);
		return true;
	}
	
	private void storeProjectData(ProjectType projectType, TargetDevice[] targetDevice)  {
		Project project = ProjectFactory.eINSTANCE.createProject();
		project.setType(projectType);
		
		if ( targetDevice != null && targetDevice.length > 0 ) {
			project.setDefaultTargetDevice(targetDevice[0]);
		}
		if ( targetDevice != null && targetDevice.length > 1 ) {
			for (int i = 1; i < targetDevice.length; i++) {
				project.getTargetDevices().add(targetDevice[i]);
			}
		}
		IPath metadataPath = MtjProject.getMetadataTemporaryStorage(getProjectName());

		try {
			MtjProject.setProjectDataTemporaryLocation(project, metadataPath);
			savedTemporaryMetadata = true;
		} catch (MtjException e) {
			e.printStackTrace();
		}

	}

	public IClasspathEntry getSrcEntry() {
		String srcbinSRCName;
		boolean useSrcAndOutputDir = PreferenceConstants.getPreferenceStore().getBoolean(PreferenceConstants.SRCBIN_FOLDERS_IN_NEWPROJ);
		if (useSrcAndOutputDir)
		{
			srcbinSRCName = PreferenceConstants.getPreferenceStore().getString(PreferenceConstants.SRCBIN_SRCNAME);		
		}
		else
			srcbinSRCName = "src"; //$NON-NLS-1$
		IPath path = new Path(sep + getProjectHandle().getName() + sep + srcbinSRCName);
		/*
		 * make a new entry each time to ensure the project name is correct.
		 */
		return JavaCore.newSourceEntry(path);
	}
	

	@Override
	public void dispose() {
		if (savedTemporaryMetadata)
			MtjProject.deleteProjectData(getProjectName());
		super.dispose();
	}
	
	public String getProjectName ()
	{
		if (getProjectHandle() != null)
			return getProjectHandle().getName();
		else
			return ""; //$NON-NLS-1$
	}
	
	public IProject getProject ()
	{
		if (javaSDKPage.isPageComplete())
			if (getProjectHandle() != null)
				return getProjectHandle().getProject();

		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.WizardPage#isPageComplete()
	 */
	@Override
	public boolean isPageComplete() {
		if (midletPage != null)
		{
			String project = getProjectName();
			midletPage.setProjectName(project);
		}
		return super.isPageComplete();
	}
	
}
