package org.eclipse.mtj.extension.devide.utils;

import java.util.Hashtable;

import org.eclipse.mtj.api.signings.SigningCertificate;

public class SmgmtCache {

	private static SmgmtCache smgmtcache = null;
	private static Hashtable cache;
	
	private SmgmtCache(){	
		cache = new Hashtable();
	}
	
	public static SmgmtCache getSmgmtCache(){
		if(smgmtcache == null){
			smgmtcache = new SmgmtCache();
		}
		return smgmtcache;
	}
	
	public boolean cacheSigningCertificate(SigningCertificate sc){
		try {
			cache.put(sc.getKeystore(), sc);
		} catch (Exception e) {
			return false;
		}
		return true;
	}
	
	public boolean lookupSigningCertificate(String key){
		return cache.containsKey(key);
	}
	
	public SigningCertificate getSigningCertificate(String key){
		return (SigningCertificate)cache.get(key);
	}
	
	public void unCacheSigningCertificate(String key){
		cache.remove(key);
	}
	
	public void unCacheSigningCertificate(SigningCertificate sc){
		cache.remove(sc.getKeystore());
	}
}
