/*******************************************************************************
 * Copyright (c) 2006 IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *******************************************************************************/

package org.eclipse.mtj.extension.bp.anttask;

import java.util.Properties;

import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.exception.MtjException;

public class BuildProviderAntTask extends BuildProviderBaseAntTask {

	Properties projectProps;

	private String binaryDir = null;
	private String classesDir = null;
	private String deployDir = null;
	private String password = null;

	boolean debug = false;

	public BuildProviderAntTask() {
		super();
	}

	public void init() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.mtj.extension.bp.anttask.BuildProviderBaseAntTask#doExecute()
	 */
	public void run() {

		try {
			if (mtjProject.getProjectData().getType() == ProjectType.PROJECT_TYPE_MIDP_LITERAL) {
				MidpPreverifyAntTask preVerify = new MidpPreverifyAntTask ();
				if (getClassesDir() != null)
					preVerify.setClassesDir(getClassesDir());
				if (getBinaryDir() != null)
					preVerify.setBinaryDir(getBinaryDir());
				preVerify.doRun(mtjProject, monitor);
			
				MidpPackagingAntTask packaging = new MidpPackagingAntTask();
				if (getDeployDir() != null)
					packaging.setDeployDir(getDeployDir());
				if (getBinaryDir() != null)
					packaging.setBinaryDir(getBinaryDir());
				packaging.doRun(mtjProject, monitor);

				if (getPassword() != null)
				{
					MidpSigningAntTask sign = new MidpSigningAntTask ();
					if (getDeployDir() != null)
						sign.setDeployDir(getDeployDir());
					sign.setPassword(getPassword());
					sign.doRun(mtjProject, monitor);
				}
			} else {
				JavaMePackagingAntTask packaging = new JavaMePackagingAntTask();
				if (getDeployDir() != null)
					packaging.setDeployDir(getDeployDir());
				if (getBinaryDir() != null)
					packaging.setBinaryDir(getBinaryDir());
				packaging.doRun(mtjProject, monitor);
			}
		} catch (MtjException e) {
			throw new BuildException (e);
		} catch (CoreException e) {
			throw new BuildException (e);
		}

	}

	/**
	 * @return Returns the deployDir.
	 */
	public String getDeployDir() {
		return deployDir;
	}

	/**
	 * @param deployDir
	 *            The deployDir to set.
	 */
	public void setDeployDir(String deployDir) {
		this.deployDir = deployDir;
	}

	/**
	 * @return Returns the deployDir.
	 */
	public String getBinaryDir() {
		return binaryDir;
	}

	/**
	 * @param deployDir
	 *            The deployDir to set.
	 */
	public void setBinaryDir(String binaryDir) {
		this.binaryDir = binaryDir;
	}

	/**
	 * @return Returns the classesDir.
	 */
	public String getClassesDir() {
		return classesDir;
	}

	/**
	 * @param classesDir The classesDir to set.
	 */
	public void setClassesDir(String classesDir) {
		this.classesDir = classesDir;
	}

	/**
	 * @return Returns the password.
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param password The password to set.
	 */
	public void setPassword(String password) {
		this.password = password;
	}

}
