/*******************************************************************************
* Copyright (c) 2006 IBM.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.bp.anttask;


import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpSigning;

public class MidpSigningAntTask extends BuildProviderBaseAntTask {

	
	boolean debug=false;
	private String password = null;
	private String deployDir = null;


	public MidpSigningAntTask() {
		super();
	}

	public void doRun (IMtjProject mtjProject, IProgressMonitor monitor) throws CoreException, MtjException 
	{
		this.mtjProject = mtjProject;
		this.monitor = monitor;

		if (mtjProject == null)
			return;

		MidpSigning signing = new MidpSigning (mtjProject, monitor);
		if (getDeployDir() != null)
			signing.setDeploymentFolder(convertProjectRelativeLocationToIFolder(getDeployDir()));

		signing.sign(getPassword());
	}
	
	public void run() {
		try {
			doRun (mtjProject, monitor);
		} catch (MtjException e) {
			throw new BuildException (e);
		} catch (CoreException e) {
			throw new BuildException (e);
		}

	}

	/**
	 * @return Returns the password.
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param password The password to set.
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return Returns the deployDir.
	 */
	public String getDeployDir() {
		return deployDir;
	}

	/**
	 * @param deployDir The deployDir to set.
	 */
	public void setDeployDir(String deploymentFolder) {
		this.deployDir = deploymentFolder;
	}

	
}
