/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.devide.jadeditor;

import org.eclipse.mtj.core.jad.IJADConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

/**
 * JAD editor page for handling the optional properties.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.2 $
 * <br>
 * $Date: 2006/09/05 15:12:25 $
 * <br>
 * @author Craig Setera
 */
public class JADOptionalPropertiesEditorPage extends JADPropertiesEditorPage {
	public static final String ID = "optional";
	
	/**
	 * Optional property descriptors.
	 */
	private static final DescriptorPropertyDescription[] 
		OPTIONAL_DESCRIPTORS = new DescriptorPropertyDescription[] {
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_PERMISSIONS,
				JadEditorStrings.property_jad_midlet_permissions,
				DescriptorPropertyDescription.DATATYPE_STRING),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_PERMISSIONS_OPTIONAL,
				JadEditorStrings.property_jad_midlet_permissions_opt,
				DescriptorPropertyDescription.DATATYPE_STRING),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_DATA_SIZE,
				JadEditorStrings.property_jad_midlet_data_size,
				DescriptorPropertyDescription.DATATYPE_INT),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_DESCRIPTION,
				JadEditorStrings.property_jad_midlet_description,
				DescriptorPropertyDescription.DATATYPE_STRING),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_ICON,
				JadEditorStrings.property_jad_midlet_icon,
				DescriptorPropertyDescription.DATATYPE_STRING),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_INFO_URL,
				JadEditorStrings.property_jad_midlet_info_url,
				DescriptorPropertyDescription.DATATYPE_URL),
		};

	/**
	 * Constract a new required properties editor.
	 * 
	 * @param editor
	 */
	public JADOptionalPropertiesEditorPage(JADEditor editor) {
		super(editor, ID, "Optional", OPTIONAL_DESCRIPTORS);
	}

	/**
	 * @see org.eclipse.mtj.extension.devide.jadeditor.AbstractJADEditorPage#getSectionTitle()
	 */
	protected String getSectionTitle() {
		return "Optional Properties";
	}

	/**
	 * @see org.eclipse.mtj.extension.devide.jadeditor.AbstractJADEditorPage#getSectionDescription()
	 */
	protected String getSectionDescription() {
		return "Optional midlet suite properties may be specified on this page";
	}
	
	protected void addContextHelp(Composite c)
	{
		PlatformUI.getWorkbench().getHelpSystem().setHelp(c, "eclipseme.ui.help_JADOptionalPropertiesEditorPage");
	}
}
